DELIMITER //
drop procedure if exists mysql.submit_arg_task;

CREATE PROCEDURE mysql.submit_arg_task( IN domain_id int,IN arg_id int,IN url_id int,IN arg_str varchar( 256 ),IN db_name varchar(64),IN tasktype int,OUT ret int ) 
label8:begin 
	DECLARE sql_str varchar( 1024 ); 
	DECLARE dup_str varchar( 256 ); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	
	START TRANSACTION;
	
		set sql_str="";
		set sql_str=concat( 'update ',db_name,'.url_args_info set arg_learn_stat=2 where id=',arg_id );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

		# do not clean this for debug info
		#set sql_str="";
		#set sql_str=concat( 'update ',db_name,'.url_args_sample_record set total_process_sample_count=0,valid_sample_count=0,sample_collect_round=0,sample_new_type=0,start_sample_id=0,start_sample_temp_id=0 where arg_id=',arg_id );
		#set @v_sql=sql_str;
		#prepare stmt from @v_sql;
		#EXECUTE stmt;
		#deallocate prepare stmt;
		
		set sql_str="";
		set sql_str=concat( 'update ',db_name,'.url_args_sample_stat set sample_collecting_stat=2 where arg_id=',arg_id );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

		set dup_str=concat( "arg_id:",arg_id,"," );
		set sql_str="";
		set sql_str=concat( "select count(*) into @cnt from ml_global.global_task_table where domain_id=",domain_id," and task_type=",tasktype," and task_parameter like '%",dup_str,"%'" );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;
		
		if( @cnt <> 0 ) then
			set ret = -1;
			ROLLBACK;			
			leave label8;
		end if;
		
		set sql_str="";
		set sql_str=concat( "insert into ml_global.global_task_table( domain_id,task_type,task_parameter,task_status ) values(" );
		set sql_str=concat( sql_str,domain_id,",");
		set sql_str=concat( sql_str,tasktype,",");
		set sql_str=concat( sql_str,"'",arg_str,"'");
		set sql_str=concat( sql_str,",0)");
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

	IF t_error = 1 THEN
		set ret = -2;
        	ROLLBACK;

	ELSE
		set ret = 0;
		COMMIT;
	END IF;

end;//
DELIMITER ;

