DELIMITER //
drop procedure if exists mysql.switch_round;

CREATE PROCEDURE mysql.switch_round( IN arg_id int,IN dbname varchar(64),IN first_sample_id int,IN target_size int,IN sample_table varchar(64),IN sample_temp_table varchar(64),OUT ret int ) 
label7:begin 
	DECLARE sql_str varchar( 1024 ); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	set @arg_id = arg_id;
	set @first_sample_id = first_sample_id;
	set @target_size = target_size;
	set @sample_table = sample_table;
	set @sample_temp_table = sample_temp_table;
	
	START TRANSACTION;
	
		set sql_str="";
		set sql_str=concat("select count(*),sample_collect_round,sample_new_type into @cnt,@round_num,@new_type from ",dbname,".url_args_sample_record where arg_id=",@arg_id );

		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

		if( @cnt <> 1 ) then
			set ret = -1;
			leave label7;
		end if;

		if( @new_type=0 ) then
			call mysql.fulfill_sample( @arg_id,dbname,@sample_table,@sample_temp_table,@first_sample_id,@target_size );		
			set ret = 1;
			COMMIT;
			leave label7;	
		end if;

		set @round_num = @round_num + 1; 
		set sql_str="";
		set sql_str=concat( "update ",dbname,".url_args_sample_record set sample_collect_round=@round_num,sample_new_type=0 where arg_id=",@arg_id );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

	IF t_error = 1 THEN
		set ret = -2;
        	ROLLBACK;

	ELSE
		set ret = 0;
		COMMIT;
	END IF;

end;//
DELIMITER ;

