import time
import os
import sys
import time
import MySQLdb
from datetime import datetime
from subprocess import *

from warnings import filterwarnings
filterwarnings('error', category = MySQLdb.Warning)

stat_data_cap = 1 #Day(s)
delay_time = 15
db_list = []
db_exist_list = {}

#0: Close
#1: Error
#2: Info
debug_level = 0

def dbg(type, args):
    print '[Bot-DB-Manager][%s]: ' % type,
    for arg in args:
        print arg,
    print ''


def DbgErr(*args):
    global debug_level
    if debug_level >= 1:
        dbg('Error', args)

def DbgInfo(*args):
    global debug_level
    if debug_level >= 2:
        dbg('Info', args)

def check_env_ready():
    cmdline = "/bin/bot_test checkready"
    result = Popen(cmdline,shell=True,stdout=PIPE,stderr=PIPE,stdin=PIPE).stdout
    for line in result.readlines():
        if str(line).find('Machine Learning Environment is Ready') != -1:
            return True
    return False

def conn_mysql_db(db_name=None):
    try:
        if db_name is None:        
            db = MySQLdb.connect(user='root')
        else:
            db = MySQLdb.connect(user='root', database=db_name)
    except MySQLdb.Warning as w:
        return None            
    except MySQLdb.OperationalError as e:
        return None
    except Exception as e:
        return None

    return db;

def get_database_list(prefix=None):
    db = None;
    cur = None;

    try:
        db = conn_mysql_db();
        if db is None:
            return 0;
        cur = db.cursor();
        cur.execute("show databases");
    except MySQLdb.Warning as w:
        pass           
    except MySQLdb.OperationalError as e:
        return 0
    except Exception as e:
        DbgErr("get_database_list() got exception. %s" % repr(e));
        if (cur != None) :
            cur.close();

        if (db != None) :
            db.close();

        return -1;

    for row in cur.fetchall() : 
        #print row[0], " ", row[1], " ", row[2]

        db_name = row[0];
        if db_name.startswith('fwbml_bot_'):
        	if db_name not in db_exist_list.keys():
        		db_exist_list[db_name] = {"name":db_name, "last_check_time":int(time.time())}
	        	DbgInfo("add %s to monitor list" % (db_name))
		
    cur.close();
    db.close();
    #print(db_exist_list)
    
def update_database_list(db_name):
	if db_name in db_exist_list.keys():
		db_exist_list[db_name]["last_check_time"] = int(time.time())

def check_database_list():
	now_time = time.time()
	for db_name in db_exist_list.keys():
		last_check_time = db_exist_list[db_name]["last_check_time"]
		lost_time = now_time - last_check_time
		DbgInfo("%s last find time %d, now time %d, lost time %d" % (db_name, last_check_time, now_time, lost_time))
		if lost_time > 300:
			DbgInfo('%s don\'t exist in table bot_db_map.' % (db_name))
			drop_database(db_name)
			db_exist_list.pop(db_name)
			
def drop_database(db_name):
	sql = "drop database if exists " + db_name

	cur = None;
	db = None;

	try:
		db = conn_mysql_db();
		if db is None:
			return 0;
		cur = db.cursor();
		cur.execute(sql);
	except MySQLdb.Warning as w:
		pass           
	except MySQLdb.OperationalError as e:
		return 0
	except Exception as e:
		DbgErr("drop_database() got exception. %s" % repr(e));
		if (cur != None) :
		    cur.close();

		if (db != None) :
		    db.close();

		return -1;
        
	DbgInfo("drop database %s successfull" % (db_name))
	cur.close();
	db.close();
    
def check_time(timestamp):
    global delay_time;

    if os.access("/var/log/ml_bot_log", os.F_OK):
        delay_time = 5;
    else:
        delay_time = 15;

    #print timestamp
    if (timestamp == None):
        return -1;

    fmt = '%Y-%m-%d %H:%M:%S'
    cur_time = datetime.now().strftime(fmt);
    tstamp1 = datetime.strptime(str(timestamp), fmt)
    tstamp2 = datetime.strptime(cur_time, fmt)

    if tstamp1 > tstamp2: 
        return 0;
    else: 
        td = tstamp2 - tstamp1 
        td_mins = int(round(td.total_seconds() / 60))
        return td_mins;
        
def delete_db(db_name, timestamp):
    minute_diff = check_time(timestamp);
    if (minute_diff < delay_time):
        return 0;
    else:
        sql1 = "set @ret = 0" 
        sql2 = "call mysql.bot_delete_db('" + db_name + "', @ret)"
        sql3 = "select @ret";
        ret = 0;

        cur = None;
        db = None;

        try:
            db = conn_mysql_db();
            if db is None:
                return 0;

            cur = db.cursor();
            cur.execute(sql1);
            cur.execute(sql2);
            cur.execute(sql3);
        except MySQLdb.Warning as w:
            pass           
        except MySQLdb.OperationalError as e:
            return 0
        except Exception as e:
            DbgErr("delete_db() got exception %s, excpetion:%s" % (db_name, repr(e)));
            if (cur != None) :
                cur.close();

            if (db != None) :
                db.close();

            return -1;
        else:
            row = cur.fetchone();
            if (row == None or row[0] != 0) :
                DbgErr("Delete DB %s failed. %s" %(db_name, row[0]));
                ret = -1;
            else:
                ret = 1;

        cur.close();
        db.close();

        return ret;

def check_db_events():
    db = None;
    cur = None;
    db_list = [];

    try:
        db = conn_mysql_db("ml_global");
        if db is None:
            return 0;
        cur = db.cursor();
        cur.execute("SELECT db_name, events, timestamp FROM bot_db_map");
    except MySQLdb.Warning as w:
        pass           
    except MySQLdb.OperationalError as e:
        return 0
    except Exception as e:
        DbgErr("check_db_events() got exception. %s" % repr(e));
        if (cur != None) :
            cur.close();

        if (db != None) :
            db.close();

        return -1;

    for row in cur.fetchall() : 
        #print row[0], " ", row[1], " ", row[2]

        db_name = row[0];
        events = row[1];
        timestamp = row[2];

        #update db_exist_list
        update_database_list(db_name)
		
        if (events == 1) :
            DbgInfo("Delete DB %s" %db_name);
            ret = delete_db(db_name, timestamp);
            if (ret == 1) :
                DbgInfo("Deleted DB %s successfully." %(db_name));
        elif (events == 0):
            db_list.append(db_name);
            pass
        else:
            DbgErr( "Wrong events value.");
    cur.close();
    db.close();

def do_detection_accuracy_table_check(db_name):
    sql = "delete from bot_detection_accuracy where stat_time < (now() - interval %d day - interval 1 hour)" % stat_data_cap;
    db = None;
    cur = None;

    try:
        db = conn_mysql_db(db_name);
        if db is None:
            return 0;
        cur = db.cursor();
        cur.execute(sql);
    except MySQLdb.Warning as w:
        pass           
    except MySQLdb.OperationalError as e:
        return 0
    except Exception as e:
        DbgErr("do_detection_accuracy_table_check() got exception1. %s" % repr(e));
        if (cur != None) :
            cur.close();

        if (db != None) :
            db.close();

        return -1;

    db.commit();
    cur.close();
    db.close();

def full_db_check():
    db = None;
    cur = None;

    try:
        db = conn_mysql_db("ml_global");
        if db is None:
            return 0;
        cur = db.cursor();
        cur.execute("SELECT db_name FROM bot_db_map where events = 0");
    except MySQLdb.Warning as w:
        pass           
    except MySQLdb.OperationalError as e:
        return 0
    except Exception as e:
        DbgErr("full_db_check() got exception. %s" % repr(e));
        if (cur != None) :
            cur.close();

        if (db != None) :
            db.close();

        return -1;

    for row in cur.fetchall() : 
        #print row[0], " ", row[1], " ", row[2]

        db_name = row[0];
        do_detection_accuracy_table_check(db_name);

    cur.close();
    db.close();

def main():
    try:
        while(1):
            if check_env_ready() == True:
                #print("Machine Learning Environment is ready.")
                break
            else:
                #print("Machine Learning Environment is not ready.")
                time.sleep(1)

        events_check_interval = 0;
        full_check_interval = 0;

        while(1):
            time.sleep(1);
            events_check_interval = events_check_interval + 1;
            full_check_interval = full_check_interval + 1;

            if (events_check_interval > 30):
                get_database_list();            
                #Scan site_info table for events. 
                check_db_events();
                check_database_list();
                events_check_interval = 0;

            if (full_check_interval > 60):
                full_db_check();
                full_check_interval = 0;

    except KeyboardInterrupt:
            sys.exit(0);

if __name__ == "__main__": 
        main()

