#!/usr/bin/python
#coding=utf-8

import requests
from urlparse import urljoin
import urllib
import sys
import getopt
import base64
import datetime
import time
import json
import random
import commands
from collections import OrderedDict
requests.packages.urllib3.disable_warnings()
def my_print(argv):
    print argv
def my_print_red(argv):
    print "\033[1;31;47m %s \033[0m"%argv

class HttpConn():
    def __init__(self ,cookies=dict()  ,proxies = None , url = "http://10.0.0.218"):
        self.cookies = cookies
        self.headers  = None
        self.proxies = proxies
        self.url = url
        self.conn = None
        #firefox
        headers = dict()
        headers['User-Agent'] = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:63.0) Gecko/20100101 Firefox/63.0'
        headers['Accept'] = 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8'
        headers['Accept-Language'] = 'zh-CN,en;q=0.8,zh;q=0.7,zh-TW;q=0.5,zh-HK;q=0.3,en-US;q=0.2'
        headers['Accept-Encoding'] = 'gzip, deflate'
        headers['Connection'] = 'keep-alive'
        headers['Upgrade-Insecure-Requests'] = '1'
        #chrom
        #headers['User-Agent']='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36'
        #headers['Accept']='text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8'
        #headers['Accept-Language']='zh-CN,zh;q=0.9'

        self.headers = headers
        #self.refer = None

    def http_get(self, url ,headers):
        try:
            if self.cookies:
                cookies = ""
                cum = ''
                for key, value in self.cookies.items():
                    cookies = cookies + cum + key + "=" + value
                    cum = "; "
                headers['Cookie']=cookies
            r = requests.get(url, headers=headers, cookies=None, proxies=self.proxies, verify=False)
            r.encoding = 'utf-8'
            if not r:
                my_print("url get: [%s] fail ..." % url)
                return None
            #r.encoding='utf-8'
            return r
        except Exception,e:
            my_print(str(e))
        return None

    def http_post(self, url ,data , headers):
        try:
            if self.cookies:
                cookies = ""
                cum = ''
                for key, value in self.cookies.items():
                    cookies = cookies + cum + key + "=" + value
                    cum = "; "
                headers['Cookie']=cookies
            r = requests.post(url, data = data , headers=headers, cookies=None, proxies=self.proxies, verify=False)
            r.encoding = 'utf-8'
            if not r:
                my_print("url post: [%s] fail ..." % url)
                return None
            #r.encoding='utf-8'
            return r
        except Exception, e:
            my_print(str(e))
        return None
    def http_conn(self):
        self.conn=requests.session()

    def conn_get(self,url ,headers):
        try:
            r = self.conn.get(url, headers=headers, proxies=self.proxies, verify=False)
            r.encoding = 'utf-8'
            if not r:
                my_print("url get: [%s] fail ..." % url)
                return None
            r.encoding = 'utf-8'
            return r
        except Exception, e:
            my_print(str(e))
        return None
    def conn_post(self, url ,data , headers ):
        try:
            r = self.conn.post(url, data = data , headers=headers,  proxies=self.proxies, verify=False)
            r.encoding = 'utf-8'
            if not r:
                my_print("url post: [%s] fail ..." % url)
                return None
            r.encoding='utf-8'
            return r
        except Exception, e:
            my_print(str(e))
        return None
    def conn_add_cookie(self):
        requests.utils.add_dict_to_cookiejar(self.conn.cookies, self.cookies)

    def conn_close(self):
        self.conn.close()

    def update_cookie(self , r):
        #print r.cookies.get_dict()
        #print r.headers['Set-Cookie']
        ckis = r.headers['Set-Cookie']
        for key, value in r.cookies.items():
            #self.cookies[key] = repr(value)
            #print key , self.cookies[key]
            self.cookies[key] = value
        key="fsuis"
        idx = ckis.find(key)
        if idx != -1:
            subb = ckis[idx:]
            lsx = subb.find(';')
            if  lsx != -1:
                #print "########-1",self.cookies[key]
                self.cookies[key]=subb[len(key)+1:lsx]
                #print "########-2",self.cookies[key]





    def response_ret(self , url , r):
        if not r:
            my_print("access url:[%s]  fail ..." % url)
            return 0
        if r.status_code != 200 and r.status_code != 301 and r.status_code != 302:
            my_print("access url:[%s]  fail ret code:[%d] ..." % (url,r.status_code))
            return 0
        self.update_cookie(r)
        return r.status_code

    def rdp_basic_auth(self , rdpurl ,user , pwd):
        try:
            headers = dict()
            headers['User-Agent'] = self.headers['User-Agent']
            headers['Accept'] = '*/*'
            headers['Accept-Language'] = self.headers['Accept-Language']
            headers['Accept-Encoding'] = self.headers['Accept-Encoding']
            headers['X-Requested-With'] = 'XMLHttpRequest'
            headers['Connection']  = self.headers['Connection']
            headers['Referer']  = self.url
            '''
            r = requests.get(rdpurl , auth = (user , pwd) ,headers=headers, cookies=self.cookies, proxies=self.proxies, verify=False)
            if r.status_code == 200:
                return True
            '''
            r=requests.get(rdpurl , headers=headers, cookies=self.cookies ,proxies=self.proxies, verify=False)

            headers['Authorization']= "Basic "+base64.b64encode(user+":"+pwd)
            r = requests.get(rdpurl, headers=headers, cookies=self.cookies ,proxies=self.proxies, verify=False)
            if r.status_code == 200:
                return True
        except Exception,e:
            my_print("fsa basic auth error"+str(e))
            return False
    def fsa_Login(self  , user='admin' ,pwd =''):
        try:
            url = self.url
            #self.http_conn()
            r = self.http_get(url , headers = self.headers )
            rcode = self.response_ret(url, r)
            if  rcode == 0:
                return None

            if 'csrftoken' not in  self.cookies:
                my_print("error cookie not found  key is csrftoken ")
                return None


            #try auth
            #self.rdp_basic_auth(urljoin(url,'/rdp/') , user,pwd)

            #login
            self.headers['Referer'] = url
            checkurl=urljoin(url ,'/logincheck')
            data = "csrfmiddlewaretoken="+self.cookies['csrftoken']+"&username="+user+"&password="+pwd+"&next=%2F&login_button=Login"
            r = self.http_post(checkurl , data = data , headers=self.headers)
            rcode = self.response_ret(checkurl , r)
            if rcode == 0:
                return None
            '''
            #again get url
            self.headers['Referer'] = checkurl
            r = self.http_get(url , headers = self.headers )
            rcode = self.response_ret(url, r)
            if  rcode == 0:
                return None
            
            #/dashboard
            self.headers['Referer'] = url
            dbdurl=urljoin(url , '/dashboard/')
            r = self.http_get(dbdurl, headers=self.headers)
            rcode = self.response_ret(dbdurl, r)
            if rcode == 0:
                return None
            if rcode == 301:
                lcation = r.headers['Location']
                print "##@@!@@#"
                r = self.http_get(dbdurl, headers=self.headers)
                rcode = self.response_ret(dbdurl, r)
                if rcode == 0:
                    return None
            '''
            #time.sleep(3)
            return self.cookies
        except Exception,e:
            my_print(str(e))
        return None

    def find_sn2(self, sn):
        try:
            '''
            self.cookies=dict()
            self.cookies['csrftoken'] = '01227e8a2e08cf1df9c8bdeb06c1e26b'
            self.cookies['django_language'] = "en-us"
            self.cookies['fsuis']='"'+r"\273\265\207'H\016\0171/\316\375\363\205\017\010\0052\355\003\017 #\361c\207\322!\036h\242l\330\206\255\202Y\054\337\254gB\364\372\001\362\022!GF\204\036~>\3325*S\335\014]\275\247\021\025\031\370X\032\344\203\275yq\245\054\3507\300\232\373\364\054x\341\216x\206\221\261\073F\031h\216HXD\017iL\213z\215<\225\031\351\003\332\242\026\316b\242-\231\330\335u\214\320\333\217\275\316kAV\231\353O\207\\aO\352\000\216\007b\032\321\015\337%o\202\354\330\277r\250\331\0204d\346X\326\260\253K\346\260\022\001w\014C\003W\311\227\363[\244C-\207'i\025\003\204G\333\054\213r)\335\006\372\334\340i\354D\356\376"+'"'
            for k, v in self.cookies.items():
                print k, len(v),v
            '''

            url = self.url
            #durl = urljoin(url, '/forticlient/?req_type=fortidevice')
            #refer = durl
            #self.refer = durl
            search_url = urljoin(url, "/forticlient/query/?&req_type=fortidevice")

            headers = dict()
            headers['User-Agent'] = self.headers['User-Agent']
            headers['Accept'] = 'application/json, text/javascript, */*; q=0.01'
            headers['Accept-Language'] = 'zh-CN,en;q=0.8,zh;q=0.7,zh-TW;q=0.5,zh-HK;q=0.3,en-US;q=0.2'
            #headers['Accept-Language']='zh-CN,zh;q=0.9'
            headers['Accept-Encoding'] = 'gzip, deflate'
            headers['Connection'] = 'keep-alive'
            headers['Upgrade-Insecure-Requests'] = '1'

            # X-Requested-With: XMLHttpRequest
            #headers['X-Requested-With'] = 'XMLHttpRequest'
            #headers['Referer'] = refer

            filters = self.get_search_args(sn)
            if not filters:
                my_print("get SN args fail ...\n")
                return None
            full_search_url = search_url + "&filters=" + urllib.quote(filters)+"&take=20&skip=0&page=1&pageSize=20"
            #my_print(full_search_url)
            r = self.http_get(full_search_url, headers)
            if r:
                #print r.content
                job = r.json()
                if job['total'] == 0:
                    my_print_red("SN:[%s] can't found in fsa." % sn)
                    return 0
                id_list = []
                for node in job['results']:
                    if (node['auth_allowed_class'] == 'hidden'):
                        id_list.append(node['fgt_devices_id'])
                    #else:
                    #    my_print_red("SN:[%s] Search success fgt_devices_id: %s has been Authorized" % (sn, node['fgt_devices_id']))
                if len(id_list) == 0:
                    return 0
                # update cookie
                #for key, value in r.cookies.items():
                #    self.cookies[key] = value

                return id_list
            return 0
        except Exception, e:
            my_print(e)

        return None

    def sn_auth(self, sn , id_list):
        try:

            url = self.url
            for id in id_list:

                refer = urljoin(url, '/scan/device_edit?id='+id)
                #self.headers['Referer']= self.refer
                r = self.http_get(refer , self.headers)
                if not r:
                    my_print("url [%s] request fail..."%refer)
                    return None
                #time.sleep(2)

                auth_url = urljoin(url, "/scan/device_update")

                #[{"device":"103","authorized":1,"inherit":1,"name":"FV-3KETE18000018","notify":1,"report":1}]
                json_arg='[{"device":"%s","authorized":1,"inherit":1,"name":"%s","notify":1,"report":1}]'%(id , sn)

                headers = dict()
                headers['Content-Type'] = 'application/json; charset=utf-8'
                # Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:63.0) Gecko/20100101 Firefox/63.0
                headers['User-Agent'] = self.headers['User-Agent']
                headers['Accept'] = self.headers['Accept']
                headers['Accept-Language'] = 'zh-CN,en;q=0.8,zh;q=0.7,zh-TW;q=0.5,zh-HK;q=0.3,en-US;q=0.2'
                headers['Accept-Encoding'] = 'gzip, deflate'
                headers['Connection'] = 'keep-alive'
                # X-Requested-With: XMLHttpRequest
                headers['X-Requested-With'] = 'XMLHttpRequest'
                headers['Referer'] = refer
                #headers['Upgrade-Insecure-Requests'] = '1'
                headers['X-CSRFToken'] = self.cookies['csrftoken']
                #my_print(headers)
                r = self.http_post(auth_url, json_arg ,headers)
                if r:
                    #print "***auth SN *** ",r.content
                    job = r.json()
                    print job
                else:
                    return None
            return True
        except Exception, e:
            my_print(e)
        return None
    def get_search_args(self ,sn):
        try:
            t = time.time()
            t = t - 10
            st=time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(t-24*60*60))
            et=time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(t))
            #'[{"keyid":"d_time","keyname":"Detection","values":[{"id":"2019-01-29 15:31:55"},{"id":"2019-01-30 15:31:55"}]},{"keyid":"fgt_devices_serial","keyname":"Serial","values":[{"id":"FV-3KETE18000018"},{"id":""}]}]'
            filters='[{"keyid":"d_time","keyname":"Detection","values":[{"id":"%s"},{"id":"%s"}]},{"keyid":"fgt_devices_serial","keyname":"Serial","values":[{"id":"%s"},{"id":""}]}]'%(st , et , sn)
            return filters
        except Exception,e:
            my_print("get_search_args error "+str(e))
        return None

def get_cookie_from_file(filename):
    cookie=None
    try:
        with open(filename, 'r') as f:
            buffer=f.read()
            #print buffer
            cookie=dict(map(lambda x:x.split('=',1),buffer.split(";")))
    except Exception,e:
        my_print(str(e))
    return cookie
def cookie_to_file(cookies,filename='tmp.json'):
    wr=json.dumps(cookies)
    with open(filename, 'w') as json_file:
        json_file.write(wr)

def fsa_auth_request(host , sn):
    if not (host and sn):
        my_print_red("SN/host is NULL");
        return False
    try:
        status, output = commands.getstatusoutput("./fsa_req %s %s"%(host,sn))
        my_print(output)
        if status == 0:
            return True
    except Exception , e:
        my_print(str(e))
        
def usage():
    my_print("usage: -h")
    my_print(" -u : username ")
    my_print(" -p : password ")
    my_print(" -n : Serial Number")
    my_print(" -d : url addr")
    my_print(" -f : cookie file")
    my_print("")
    my_print('exsample : fsa_auto.py -u admin -p "" -n FV-3KETE18000018 -d https://10.0.0.218/')
    my_print('           fsa_auto.py -n FV-3KETE18000018 -d http://10.0.0.218/ -f /path/cookie.txt')


def argv_parse(argv):
    username=None
    passwd=None
    url=None
    sn=None
    cki=None
    try:
        opts, args = getopt.getopt(argv, "n:u:p:d:f:h")
        for op, values in opts:
            if op == "-n":
                sn = values
                if len(sn) < 5:
                    my_print("error Serial Number .")
                    exit(1)
            elif op == "-u":
                username = values
                if len(username) == 0:
                    my_print("error username .")
                    exit(1)
            elif op == "-p":
                passwd = values
            elif op == "-d":
                url = values
                if len(url) == 0:
                    my_print("error url .")
                    exit(1)
            elif op == "-f":
                cki = values
                if len(cki) == 0:
                    my_print("error cookie file .")
                    exit(1)
            elif op == "-h":
                usage()
                exit(0)
            else:
                my_print("arg error.")
                exit(0)
    except Exception,e:
        my_print("argv_parse error: [%s]"%str(e))
    return (username,passwd,url,sn ,cki)
def main():
    if len(sys.argv) == 1:
        usage()
        return -1
    username, passwd, url ,sn,cki=argv_parse(sys.argv[1:])
    if not (url and sn):
        usage()
        return -1
    while True:
        if cki:
            cookies=get_cookie_from_file(cki)
            if not cookies:
                return -1
            HC = HttpConn(cookies=cookies , url=url)
        else:
            if not (username and (not passwd is None)):
                my_print("not found username or password.")
                return -1
            HC=HttpConn(url=url)
            r = HC.fsa_Login( username , passwd)
            if not r:
                my_print("error exit .")
                return -1
	    #cookie_to_file(HC.cookies)
            #time.sleep(10)
        #search_num=0
        id = HC.find_sn2(sn)
        if id is None:
            my_print_red("Request failed, try again.")
            time.sleep(2)
            continue
        elif id == 0:
            my_print_red("sn:[%s] had Authorized ."%sn)
            return 0
        elif isinstance(id,list):
            ret=HC.sn_auth(sn ,id)
            if ret:
                my_print_red("sn:[%s] Authorized Success."%sn)
            else:
                my_print_red("Request Authorized failed, try again.")
                time.sleep(2)
                continue
        else:
            my_print_red("unknow error.")
            return -1
        return 0


if __name__ == "__main__":
    exit(main())
