import time
import os
import sys
import MySQLdb
import redis 
from datetime import datetime

from warnings import filterwarnings
filterwarnings('error', category = MySQLdb.Warning)

def conn_mysql_db(db_name):
	db = MySQLdb.connect(user='root', database=db_name);
	return db;

def remove_global_db():
	sql = "drop database if exists ml_global"

	cur = None;
	db = None;

	try:
		db = MySQLdb.connect(user='root');
		cur = db.cursor();
		cur.execute(sql);
	except MySQLdb.Warning as w:
		if (cur != None) :
			cur.close();
		if (db != None) :
			db.close();	
		return -1
	except Exception, e:
		print("remove_global_db() got exception, excpetion:%s" % ( repr(e)));
		if (cur != None) :
			cur.close();
		if (db != None) :
			db.close();
		return -1;

	cur.close();
	db.close();

	return 0;

def drop_database(db_name):
	sql = "drop database if exists " + db_name

	cur = None;
	db = None;

	try:
		db = MySQLdb.connect(user='root');
		cur = db.cursor();
		cur.execute(sql);
	except MySQLdb.Warning as w:
		pass		
	except Exception, e:
		print("drop_database() got exception for domain %s, excpetion:%s" % (db_name, repr(e)));
		if (cur != None) :
			cur.close();
		if (db != None) :
			db.close();
		return -1;

	cur.close();
	db.close();

	return 0;

def drop_table(db_name, table_name):
	sql = "drop table if exists " + table_name
	
	cur = None;
	db = None;

	try:
		db = conn_mysql_db(db_name);
		cur = db.cursor();
		cur.execute(sql);
	except MySQLdb.Warning as w:
		pass		
	except Exception, e:
		print("Drop Table(%s.%s) got exception, excpetion:%s" % (db_name, table_name, repr(e)));
		if (cur != None) :
			cur.close();
		if (db != None) :
			db.close();
		return -1;

	cur.close();
	db.close();

	return 0;

def clean_table(db_name, table_name):
	sql = "TRUNCATE table " + table_name
	
	cur = None;
	db = None;

	try:
		db = conn_mysql_db(db_name);
		cur = db.cursor();
		cur.execute(sql);
	except MySQLdb.Warning as w:
		pass		
	except Exception, e:
		print("Clear Table(%s.%s) got exception, excpetion:%s" % (db_name, table_name, repr(e)));
		if (cur != None) :
			cur.close();
		if (db != None) :
			db.close();
		return -1;

	cur.close();
	db.close();

	return 0;

def clean_global_db():
	
	table_list = ['bot_task_table', 'bot_event', 'bot_db_map']
	#clear tables
	for tab in table_list:
		clean_table('ml_global', tab)
	
	return ;

def remove_domain_db(db_name):
	return drop_database(db_name)

def remove_domain_url(r, dbid):
    for urlstr in r.scan_iter("url*:"+dbid+":*", count=100):
            r.delete(urlstr)
    r.delete("url:ids:"+dbid)

def remove_domain_arg(r, dbid):
    for argstr in r.scan_iter("arg*:"+dbid+":*", count=100):
            r.delete(argstr)

def remove_domain_db_all():
        r = redis.Redis(host = '127.0.0.1', port = 6379, decode_responses = False)
        if (r.ping() != True):
            return -1

        for dm in r.scan_iter("domain_info:*", count=100):
            mysql_dbname = r.hget(dm, "mysql_dbname")
            if (mysql_dbname != None):
                remove_domain_db(mysql_dbname);

#        r.delete("domain_to_del")
#        r.delete("url_to_del")
#        r.delete("arg_to_del")
#        for dm in r.scan_iter("domain_info:*", count=100):
#            mysql_dbname = r.hget(dm, "mysql_dbname")
#            print mysql_dbname
#            if (mysql_dbname != None):
#                remove_domain_db(mysql_dbname);
#            dbid = dm.split(":")[1]
#            for sitestr in r.scan_iter("sitestats:"+dbid+":*", count=100):
#                r.delete(sitestr)
#            remove_domain_url(r, dbid)
#            remove_domain_arg(r, dbid)
#            r.delete(dm)
#            r.delete("arg:event:"+dbid)

        r.flushdb()
#        r.delete("domains")
#        r.delete("siteversion")
        return 0


def remove_bot_db(db_name):
	return drop_database(db_name)

def remove_bot_db_all():
	db = None;
	cur = None;

	try:
		db = conn_mysql_db("ml_global");
		cur = db.cursor();
		cur.execute("SELECT db_name FROM bot_db_map");
	except MySQLdb.Warning as w:
		pass		
	except Exception as e:
		#print("remove_bot_db_all() got exception. %s" % (repr(e)));
		if (cur != None) :
			cur.close();

		if (db != None) :	
			db.close();

		return -1;

	for row in cur.fetchall() : 
		db_name = row[0];
		remove_bot_db(db_name);

	cur.close();
	db.close();

def main():
	try:
		#ret = -1 
                #count = 0
                #while(ret < 0 and count < 10):
                    #ret = remove_domain_db_all()
                    #count=count+1
		remove_bot_db_all()
		#remove_global_db()
		clean_global_db()
	except KeyboardInterrupt:
		sys.exit(0);

if __name__ == "__main__": 
	main()

