#!/bin/sh

#####################################################
#
# feature list:
# 1. add server item for certain realm
# 2. delete server item for certain realm
# 3. edit server item for certain realm
#
#####################################################

# internal variables
_KRB_CONF="/data/etc/krb5.conf"
_LINE_NUM=0
_LOG_CONF="/var/log/krb.log"
# external parameters
ACTION="x"
SERVER_IP="x"
SERVER_PORT="x"
OLD_SERVER_IP="x"
OLD_SERVER_PORT="x"
REALM="x"

usage()
{
    echo "usage: $0 -a action args..." >& 2
    echo "    action list:" >& 2
    echo "        add - add server item for certain realm" >& 2
    echo "           -s: server_ip" >& 2
    echo "           -p: server_port" >& 2
    echo "           -r: certain realm" >& 2
    echo >& 2
    echo "        edit - edit server item for certain realm" >& 2
    echo "           -s: server_ip" >& 2
    echo "           -p: server_port" >& 2
    echo "           -S: old_server_ip" >& 2
    echo "           -P: old_server_port" >& 2
    echo "           -r: certain realm" >& 2
    echo >& 2
    echo "        delete - delete server item for certain realm" >& 2
    echo "           -s: server_ip" >& 2
    echo "           -p: server_port" >& 2
    echo "           -r: certain realm" >& 2
    echo >& 2
    echo "        delrealm - delete certain realm" >& 2
    echo "           -r: certain realm" >& 2
    echo >& 2
	echo "    examples:" >& 2
    echo "        $0 -a add -s '192.168.1.1' -p 88 -r 'TEST.RELAM'" >& 2
    echo "        $0 -a edit -s '192.168.1.1' -p 88 -S '192.168.1.2' -P 88 -r 'TEST.RELAM'" >& 2
    echo "        $0 -a delete -s '192.168.1.1' -p 88 -r 'TEST.RELAM'" >& 2
    echo "        $0 -a delrealm -r 'TEST.RELAM'" >& 2
    echo >& 2
}

while getopts a:s:p:r:S:P: arg
    do
        case $arg in
            a) ACTION=$OPTARG;;

            s) SERVER_IP=$OPTARG;;

            p) SERVER_PORT=$OPTARG;;

            r) 
                REALM=$OPTARG
                REALM=$(echo $REALM | tr '[a-z]' '[A-Z]')
                ;;

            S) OLD_SERVER_IP=$OPTARG;;

            P) OLD_SERVER_PORT=$OPTARG;;

            *) usage
               exit 1;;
        esac
    done

err_exit()
{
    echo "$@" >> $_LOG_CONF 
    exit 1
}

add_server_item()
{
	if [ $SERVER_IP = "x" ] || [ $SERVER_PORT = "x" ] || \
		[ $REALM = "x" ]; then
		usage
		exit 1
	fi

	if [ ! -f $_KRB_CONF ]; then
		err_exit "can't find krb_conf_file: $_KRB_CONF"
	fi

	if [ $_LINE_NUM -eq 0 ]; then
		_LINE_NUM=`cat -n $_KRB_CONF |sed -n "/\s\+$REALM = {/,/}/p"|grep }|cut -f 1|head -1`
	fi
	if [ -z $_LINE_NUM ] || [ $_LINE_NUM -lt 5 ]; then
		err_exit "add_item can not find $SERVER_IP:$SERVER_PORT in $REALM"
	fi

	sed -i  "$_LINE_NUM i\\\t\tkdc = $SERVER_IP:$SERVER_PORT" $_KRB_CONF ||
		err_exit "add_item can not add $SERVER_IP:$SERVER_PORT in $REALM"
}

delete_server_item()
{
	if [ $SERVER_IP = "x" ] || [ $SERVER_PORT = "x" ] || \
		[ $REALM = "x" ]; then
		usage
		exit 1
	fi

	if [ ! -f $_KRB_CONF ]; then
		err_exit "can't find krb_conf_file: $_KRB_CONF"
	fi

	_LINE_NUM=`cat -n $_KRB_CONF |sed -n "/\s\+$REALM = {/,/}/p"|grep "\ $SERVER_IP:$SERVER_PORT$"|cut -f 1|head -1`
	if [ -z $_LINE_NUM ] || [ $_LINE_NUM -lt 5 ]; then
		err_exit "del_item can not find $SERVER_IP:$SERVER_PORT in $REALM"
	fi

	sed -i "$_LINE_NUM d" $_KRB_CONF ||
		err_exit "del_item can not delete $SERVER_IP:$SERVER_PORT in $REALM"
}

edit_server_item(){
	if [ $SERVER_IP = "x" ] || [ $SERVER_PORT = "x" ] || \
		[ $REALM = "x" ] || [ $OLD_SERVER_IP = "x" ] || \
		[ $OLD_SERVER_PORT = "x" ]; then
		usage
		exit 1
	fi

	#backup
	_tmp_server_ip=$SERVER_IP
	_tmp_server_port=$SERVER_PORT

	SERVER_IP=$OLD_SERVER_IP
	SERVER_PORT=$OLD_SERVER_PORT

	delete_server_item

	#revert
	SERVER_IP=$_tmp_server_ip
	SERVER_PORT=$_tmp_server_port

	add_server_item
}

delete_realm()
{
	if [ $REALM = "x" ]; then
		usage
		exit 1
	fi

	sed -i "/\s\+$REALM/{:a;N;/}\n/!ba;d}" $_KRB_CONF ||
		err_exit "can not find $REALM"
}
case $ACTION in
    add)
        add_server_item
        ;;

    edit)
        edit_server_item
        ;;

    delete)
        delete_server_item
        ;;

    delrealm)
        delete_realm
        ;;
    *)
        usage
        exit 1
        ;;
esac

exit 0

