#!/usr/bin/env bash

#
#	Add/Delete port mapping for 
#

dk_act=""
dk_name=""
dk_pubport=""
dk_intport=""
dk_ip=""
dk_transport_protocol=""

function _usage()
{
	echo "docker-fwb-portmap.sh <options>"
	echo "    add or delete port mapping for fortiweb container"
	echo " -a:           add port mapping"
	echo " -d:           delete port mapping"
	echo " -n:           container name"
	echo " -p:           public port"
	echo " -i:           internal port"
	echo " -P:           transport protocol tcp or udp"
	echo " -h:           help message"
	echo ""
}

function _parse_cmd()
{
	while getopts ":hadn:p:i:P:" opt; do
		case $opt in
			a)
				dk_act="add"
				;;
			d)
				dk_act="delete"
				;;
			n)
				dk_name=$OPTARG
				;;
			p)
				dk_pubport=$OPTARG
				;;
			i)
				dk_intport=$OPTARG
				;;
			P)
				dk_transport_protocol=$OPTARG
				;;
			h)
				_usage
				exit 0
				;;
			?)
				echo "invalid option $opts"
				exit -1
				;;
		esac
	done

	if [ x$dk_act == x"" ]; then
		echo "need provide action: -a/-d"
		exit -1
	fi

	if [ x$dk_name == x"" ]; then
		echo "need provide container name"
		exit -1
	fi

	if [ x$dk_pubport == x"" ]; then
		echo "need provide public port"
		exit -1
	fi

	if [ x$dk_intport == x"" ]; then
		echo "need provide internal port"
		exit -1
	fi
}

function _get_container_ip()
{
	dk_ip=$(docker container inspect $dk_name | grep "\<IPAddress\>" | awk  'BEGIN{FS=":"} {print $2}' | head -n 1 | awk 'BEGIN{FS=","} {print $1}' | tr -d '"')
	#echo "container $dk_name ip is $dk_ip"
}

function _add_port_mapping()
{
	iptables -t filter -A DOCKER -p tcp -m tcp \! -i docker0 -o docker0 -s 0.0.0.0/0 -d $dk_ip --dport $dk_intport -j ACCEPT
	iptables -t nat -A DOCKER -p tcp -m tcp \! -i docker0 -d 0.0.0.0/0 --dport $dk_pubport -j DNAT --to-destination $dk_ip:$dk_intport
	iptables -t nat -A POSTROUTING -p tcp -m tcp -s $dk_ip -d $dk_ip --dport $dk_pubport -j MASQUERADE
}

function _del_port_mapping()
{
	iptables -t filter -D DOCKER -p tcp -m tcp \! -i docker0 -o docker0 -s 0.0.0.0/0 -d $dk_ip --dport $dk_intport -j ACCEPT
	iptables -t nat -D DOCKER -p tcp -m tcp \! -i docker0 -d 0.0.0.0/0 --dport $dk_pubport -j DNAT --to-destination $dk_ip:$dk_intport
	iptables -t nat -D POSTROUTING -p tcp -m tcp -s $dk_ip -d $dk_ip --dport $dk_pubport -j MASQUERADE
}

function _add_udp_port_mapping()
{
	iptables -t filter -A DOCKER -p udp -m udp \! -i docker0 -o docker0 -s 0.0.0.0/0 -d $dk_ip --dport $dk_intport -j ACCEPT
	iptables -t nat -A DOCKER -p udp -m udp \! -i docker0 -d 0.0.0.0/0 --dport $dk_pubport -j DNAT --to-destination $dk_ip:$dk_intport
	iptables -t nat -A POSTROUTING -p udp -m udp -s $dk_ip -d $dk_ip --dport $dk_pubport -j MASQUERADE
}

function _del_udp_port_mapping()
{
	iptables -t filter -D DOCKER -p udp -m udp \! -i docker0 -o docker0 -s 0.0.0.0/0 -d $dk_ip --dport $dk_intport -j ACCEPT
	iptables -t nat -D DOCKER -p udp -m udp \! -i docker0 -d 0.0.0.0/0 --dport $dk_pubport -j DNAT --to-destination $dk_ip:$dk_intport
	iptables -t nat -D POSTROUTING -p udp -m udp -s $dk_ip -d $dk_ip --dport $dk_pubport -j MASQUERADE
}

_parse_cmd $*

_get_container_ip

if [ `id -u` -ne 0 ]; then
	echo "need run as root user"
	exit -1
fi

if [ x$dk_act == x"add" ]; then
	if [ x$dk_transport_protocol == x"udp" ]; then
		echo "add port map for container $dk_name $dk_ip(udp $dk_pubport->$dk_intport)"
		_add_udp_port_mapping
	else
		echo "add port map for container $dk_name $dk_ip(tcp $dk_pubport->$dk_intport)"
		_add_port_mapping
	fi
else
	if [ x$dk_transport_protocol == x"udp" ]; then
		echo "del port map for conatiner $dk_name $dk_ip(udp $dk_pubport->$dk_intport)"
		_del_udp_port_mapping
	else
		echo "del port map for conatiner $dk_name $dk_ip(tcp $dk_pubport->$dk_intport)"
		_del_port_mapping
	fi
fi




