#!/bin/bash

dk_name=""
dk_image=""
dk_http="8080"
dk_https="8443"
dk_ssh="8022"
dk_telnet="8023"
dk_mgmt="90"
dk_policy_http="80"
dk_policy_https="443"
dk_memory="4096"
dk_env=""
dk_extra=""

function _usage()
{
	echo "docker-fwb.sh FortiWeb docker tool"
	echo " -h:	help message"
	echo " -i:	image name"
	echo " -e:	image environment variable random password"
	echo " -n:	container name"
	echo " -g:	HTTP(gui) port"
	echo " -G:	HTTPS(gui) port"
	echo " -s:	SSH port"
	echo " -t:	telnet port"
	echo " -M:	centralized management port"
	echo " -H:	policy HTTP port"
	echo " -S:	policy HTTPS port"
	echo " -x:	extra policy port mapping(xxx:xx)"
	echo " -m:	limit container's access to memory(M)"
	echo "example: ./docker-fwb.sh -i fortiweb-image -n fortiweb-docker"
	echo ""
}


function _parse_cmd()
{
	while getopts ":hi:n:e:g:G:s:t:M:H:S:m:x:" opt; do
		case $opt in
			h)	
				_usage
				exit 0
				;;
			n)
				dk_name=$OPTARG
				;;
			e)
				dk_env=$OPTARG
				;;
			i)
				dk_image=$OPTARG
				;;
			g)
				dk_http=$OPTARG
				;;
			G)	
				dk_https=$OPTARG
				;;
			s)
				dk_ssh=$OPTARG
				;;
			t)
				dk_telnet=$OPTARG
				;;
			M)
				dk_mgmt=$OPTARG
				;;
			H)
				dk_policy_http=$OPTARG
				;;
			S)
				dk_policy_https=$OPTARG
				;;
			m)
				dk_memory=$OPTARG
				;;
			x)
				dk_extra="$dk_extra -p $OPTARG"
				;;
			?)	
				echo "invalid option $opts"
				exit -1;
				;;
		esac

	done

	if [ x$dk_image == x"" ]; then
		echo "need provide image name"
		exit -1
	fi

	if [ x$dk_name == x"" ]; then
		echo "need provide container name"
		exit -1
	fi

	if [ x$dk_env != x"" ]; then
		dk_env=" --env FWB_ADMIN_PASSWORD=$dk_env"
	fi
}

function _add_port_map()
{
	dk_portmap="-p $dk_http:8"
	
	dk_portmap="$dk_portmap -p $dk_mgmt:9"

	dk_portmap="$dk_portmap -p $dk_https:43"

	dk_portmap="$dk_portmap -p $dk_ssh:22"

	dk_portmap="$dk_portmap -p $dk_telnet:23"

	dk_portmap="$dk_portmap -p $dk_policy_http:80"

	dk_portmap="$dk_portmap -p $dk_policy_https:443"
}

_parse_cmd $*

dk_portmap=""

_add_port_map

dk_caps="--cap-add net_admin --cap-add net_raw --cap-add=sys_ptrace --privileged"

dk_memory="--memory=$dk_memory""m"

docker run  -itd $dk_memory $dk_env --name $dk_name $dk_portmap $dk_extra $dk_caps $dk_image

