/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.impl.util.ValidateUtil;

public final class LockoutPolicy {
    public static final long NO_AUTO_UNLOCK = 0L;
    public static final int DESCRIPTION_LENGTH_LIMIT = 120;
    public static final long FAILED_ATTEMPT_INTERVAL_LIMIT_SEC = 1000000000L;
    public static final long AUTO_UNLOCK_INTERVAL_LIMIT_SEC = 1000000000L;
    private final String _description;
    private final long _failedAttemptIntervalSec;
    private final int _maxFailedAttempts;
    private final long _autoUnlockIntervalSec;

    public LockoutPolicy(String description, long failedAttemptIntervalSec, int maxFailedAttempts, long autoUnlockIntervalSec) {
        ValidateUtil.validateNotEmpty(description, "description");
        ValidateUtil.validateRange(description.length(), "length of description", 1L, 120L);
        ValidateUtil.validateRange(failedAttemptIntervalSec, "failedAttemptIntervalSec", 1L, 1000000000L);
        ValidateUtil.validatePositiveNumber(maxFailedAttempts, "maxFailedAttempts");
        ValidateUtil.validateRange(autoUnlockIntervalSec, "autoUnlockIntervalSec", 0L, 1000000000L);
        this._description = description;
        this._failedAttemptIntervalSec = failedAttemptIntervalSec;
        this._maxFailedAttempts = maxFailedAttempts;
        this._autoUnlockIntervalSec = autoUnlockIntervalSec;
    }

    public String getDescription() {
        return this._description;
    }

    public long getFailedAttemptIntervalSec() {
        return this._failedAttemptIntervalSec;
    }

    public int getMaxFailedAttempts() {
        return this._maxFailedAttempts;
    }

    public long getAutoUnlockIntervalSec() {
        return this._autoUnlockIntervalSec;
    }
}

