/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.PasswordFormat;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;

public class PasswordPolicy {
    public static final int DESCRIPTION_LENGTH_LIMIT = 120;
    private final String _description;
    private final int _prohibitedPreviousPasswordsCount;
    private final PasswordFormat _passwordFormat;
    private final Integer _passwordLifetimeDays;

    public PasswordPolicy(String description, int prohibitedPreviousPasswordsCount, PasswordFormat passwordFormat, Integer passwordLifetimeDays) {
        ValidateUtil.validateNotNull(passwordFormat, "passwordFormat");
        ValidateUtil.validateNotEmpty(description, "description");
        ValidateUtil.validateRange(description.length(), "length of description", 1L, 120L);
        this._description = description;
        this._prohibitedPreviousPasswordsCount = prohibitedPreviousPasswordsCount;
        this._passwordFormat = passwordFormat;
        this._passwordLifetimeDays = passwordLifetimeDays;
    }

    public String getDescription() {
        return this._description;
    }

    public int getProhibitedPreviousPasswordsCount() {
        return this._prohibitedPreviousPasswordsCount;
    }

    public PasswordFormat getPasswordFormat() {
        return this._passwordFormat;
    }

    public Integer getPasswordLifetimeDays() {
        return this._passwordLifetimeDays;
    }

    public String toString() {
        return "PasswordPolicy [description=" + this._description + ", prohibitedPreviousPasswordsCount=" + this._prohibitedPreviousPasswordsCount + ", passwordFormat=" + this._passwordFormat + ", passwordLifetimeDays=" + this._passwordLifetimeDays + "]";
    }
}

