/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.util;

import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class LocalAboutInfoAccess {
    private static final String ABOUT_INFO_PROPERTIES = "/com/vmware/vim/sso/about-info.properties";
    private static final String ABOUT_BUILD_NUMBER = "build-number";
    private static final String ABOUT_API_REVISION = "api-revision";
    public static final LocalAboutInfo LOCAL_ABOUT_INFO = LocalAboutInfoAccess.loadLocalAboutInfo();

    private static LocalAboutInfo loadLocalAboutInfo() {
        InputStream aboutInfoStr = LocalAboutInfoAccess.class.getResourceAsStream(ABOUT_INFO_PROPERTIES);
        if (aboutInfoStr == null) {
            throw new ExceptionInInitializerError(String.format("Missing required resources: %s (corrupt deployment?)", ABOUT_INFO_PROPERTIES));
        }
        Properties aboutInfoProps = new Properties();
        try {
            aboutInfoProps.load(aboutInfoStr);
            String buildNumber = aboutInfoProps.getProperty(ABOUT_BUILD_NUMBER);
            String apiRevision = aboutInfoProps.getProperty(ABOUT_API_REVISION);
            if (ValidateUtil.isEmpty(buildNumber) || ValidateUtil.isEmpty(apiRevision)) {
                throw new ExceptionInInitializerError("Missing required AboutInfo property");
            }
            LocalAboutInfo localAboutInfo = new LocalAboutInfo(buildNumber, apiRevision);
            return localAboutInfo;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (RuntimeException e) {
            throw new ExceptionInInitializerError(e);
        }
        finally {
            try {
                aboutInfoStr.close();
            }
            catch (IOException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    public static final class LocalAboutInfo {
        private final String buildNumber;
        private final String apiRevision;

        private LocalAboutInfo(String buildNumber, String apiRevision) {
            this.buildNumber = buildNumber;
            this.apiRevision = apiRevision;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public String getApiRevision() {
            return this.apiRevision;
        }
    }
}

