/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;

public final class AskPasswd {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ConsoleApi api = (ConsoleApi)Native.loadLibrary((String)"kernel32", ConsoleApi.class, (Map)W32APIOptions.UNICODE_OPTIONS);
        WinNT.HANDLE console = api.GetStdHandle(-10L);
        AskPasswd.osCheck("GetStdHandle", console != null);
        long[] origMode = new long[1];
        AskPasswd.osCheck("GetConsoleMode", api.GetConsoleMode(console, origMode));
        try {
            long noecho = origMode[0] & 0xFFFFFFFFFFFFFFFBL;
            AskPasswd.osCheck("SetConsoleMode", api.SetConsoleMode(console, noecho));
            String passwd = new BufferedReader(new InputStreamReader(System.in)).readLine();
            System.out.println(passwd);
        }
        catch (IOException e) {
            System.err.println(String.format("I/O error reading from console: %s: %s", e.getClass().getName(), e.getMessage()));
        }
        finally {
            api.SetConsoleMode(console, origMode[0]);
        }
    }

    private static void osCheck(String call, boolean successfull) {
        if (!successfull) {
            System.err.println(String.format("%s error: %s", call, Kernel32Util.formatMessageFromLastErrorCode((int)Kernel32.INSTANCE.GetLastError())));
        }
    }

    public static interface ConsoleApi
    extends WinNT {
        public static final long STD_INPUT_HANDLE = -10L;
        public static final long STD_OUTPUT_HANDLE = -11L;
        public static final long STD_ERROR_HANDLE = -12L;
        public static final long ENABLE_ECHO_INPUT = 4L;

        public WinNT.HANDLE GetStdHandle(long var1);

        public boolean GetConsoleMode(WinNT.HANDLE var1, long[] var2);

        public boolean SetConsoleMode(WinNT.HANDLE var1, long var2);
    }
}

