/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg;

import com.vmware.sso.cfg.Parameters;
import com.vmware.sso.cfg.SsoNodeType;
import com.vmware.sso.cfg.components.AbortExecution;
import com.vmware.sso.cfg.components.LookupServiceTools;
import com.vmware.sso.cfg.components.RollbackSupport;
import com.vmware.sso.cfg.components.ServerSslConfig;
import com.vmware.sso.cfg.components.ServerSslConfigFactory;
import com.vmware.sso.cfg.components.ServerTools;
import com.vmware.sso.cfg.components.ServiceControl;
import com.vmware.sso.cfg.components.ServiceControlException;
import com.vmware.sso.cfg.logging.LogConst;
import com.vmware.sso.cfg.runkit.CommandFailedException;
import com.vmware.sso.cfg.runkit.RunKit;
import com.vmware.sso.cfg.store.WinRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigureWindowsSslCommand {
    private static final String SSO_SERVICE = "ssotomcat";
    private static final String SSO_CONFIGURATION_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\VMware, Inc.\\VMware Infrastructure\\SSOServer";
    private static final String ERROR_CREATE_KEYSTORE = "Internal error creating in-memory keystore: %s (incompatible JRE?)";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RunKit kit;
    private final ServerSslConfigFactory sslConfigFactory;
    private final ServiceControl serviceCtl;
    private final WinRegistry registry;
    private final ServerTools serverTools;
    private final RollbackSupport rollback;

    @Inject
    public ConfigureWindowsSslCommand(RunKit kit, ServerSslConfigFactory sslConfigFactory, ServiceControl serviceCtl, WinRegistry registry, ServerTools serverTools, RollbackSupport rollback) {
        this.kit = kit;
        this.sslConfigFactory = sslConfigFactory;
        this.serviceCtl = serviceCtl;
        this.registry = registry;
        this.serverTools = serverTools;
        this.rollback = rollback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Parameters params) {
        File homeDir = this.findInstallDir();
        if (!this.haveWorkToDo(params)) {
            this.log.info("No parameters provided that require configuration changes. End.");
            return 0;
        }
        this.validateMasterPassword(params.getMasterPassword(), homeDir);
        boolean ssoWasRunning = this.stopSsoIfNecessary();
        this.log.info("Beginning certificate replacement procedure for Single Sign-On.");
        ServerSslConfig sslConfig = params.shouldGenerate() ? this.sslConfigFactory.generate("vCenter Single Sign-on", params.getHostname()) : params.getSslConfig();
        this.rollback.prepareRollback(homeDir, RollbackSupport.RollbackDirection.Backup);
        try {
            this.updateContainerConfiguration(homeDir, sslConfig, params.getMasterPassword());
            this.updateLsConfiguration(homeDir, sslConfig, params);
            this.rollback.rollbackComplete();
            int n = 0;
            return n;
        }
        catch (RuntimeException e) {
            int n = this.undo(e, homeDir);
            return n;
        }
        catch (Exception e) {
            int n = this.undo(e, homeDir);
            return n;
        }
        finally {
            this.restartSsoIfNecessary(ssoWasRunning);
        }
    }

    private void validateMasterPassword(String masterPassword, File homeDir) {
        this.log.info("Verifying master password.");
        HashMap<String, Object> spec = new HashMap<String, Object>();
        spec.put("cmd", Arrays.asList(new File(homeDir, "utils/rsautil.cmd"), "-S", "manage-secrets", "-m", this.kit.secret(masterPassword), "-a", "list"));
        spec.put("stdout", new NullOutputStream());
        spec.put("check", false);
        spec.put("quiet", true);
        int status = this.kit.run(spec);
        if (status != 0) {
            throw new AbortExecution("The provided master password is incorrect.", 3);
        }
    }

    public boolean haveWorkToDo(Parameters params) {
        boolean haveLbWork = params.getNodeType() != SsoNodeType.Single && (params.getLbHostname() != null || params.getLbCertificate() != null);
        boolean haveNodeWork = params.getSslConfig() != null || params.shouldGenerate() || params.getHostname() != null;
        return haveLbWork || haveNodeWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rollback(Parameters params) {
        File homeDir = this.findInstallDir();
        this.rollback.prepareRollback(homeDir, RollbackSupport.RollbackDirection.Restore);
        boolean ssoWasRunning = this.stopSsoIfNecessary();
        try {
            this.undo(null, homeDir);
        }
        finally {
            this.restartSsoIfNecessary(ssoWasRunning);
        }
        return 0;
    }

    private File findInstallDir() {
        this.log.info(LogConst.MARK_VERBOSE, "Reading vCenter Single Sign-On Server installation directory from {}.", (Object)SSO_CONFIGURATION_KEY);
        String homeDirName = this.registry.queryStringValue(SSO_CONFIGURATION_KEY, "InstallPath");
        if (StringUtils.isBlank(homeDirName)) {
            throw new AbortExecution("Cannot find Single Sign-On Server installation on this machine.", 2);
        }
        File homeDir = new File(homeDirName);
        if (!homeDir.exists() || !homeDir.isDirectory()) {
            throw new AbortExecution("Single Sign-On installation recorded as {} but the path does not exist or is not a directory. The installation is either corrupt or not present at this machine. Qutting.", 2);
        }
        this.log.info("Found vCenter Single Sign-On Server installation in: {}", (Object)homeDirName);
        return homeDir;
    }

    private boolean stopSsoIfNecessary() {
        boolean ssoWasRunning = false;
        this.log.debug("Checking if vCenter Single Sign-On service is running.");
        if (this.serviceCtl.isRunning(SSO_SERVICE)) {
            ssoWasRunning = true;
            this.log.info("The vCenter Single Sign-On service is currently running but it must be stopped in order to perform the SSL certificate update operation.");
            this.log.info(LogConst.MARK_VERBOSE, "Stopping the vCenter Single Sign-On service.");
            this.serviceCtl.stop(SSO_SERVICE);
        }
        return ssoWasRunning;
    }

    private void restartSsoIfNecessary(boolean ssoWasRunning) {
        if (ssoWasRunning) {
            this.log.info("Starting vCenter Single Sign-On service.");
            try {
                this.serviceCtl.start(SSO_SERVICE);
            }
            catch (ServiceControlException e) {
                this.log.warn("Service {} cannot be started automatically: {} Try starting it manually.", (Object)SSO_SERVICE, (Object)e.getMessage());
                this.log.debug("", (Throwable)e);
            }
        }
    }

    private void updateContainerConfiguration(File homeDir, ServerSslConfig sslConfig, String masterPassword) {
        String idPasswd = ConfigureWindowsSslCommand.randomPassword();
        String trustPasswd = "changeit";
        KeyStore idStore = this.createIdStore(sslConfig, idPasswd);
        KeyStore trustStore = this.createTrustStore(sslConfig, trustPasswd);
        File idStoreFile = new File(homeDir, "security/server-identity.jks");
        this.rollback.moveToBackup(idStoreFile);
        this.persistKeyStore(idStoreFile, idStore, idPasswd);
        File trustStoreFile = new File(homeDir, "security/root-trust.jks");
        this.rollback.moveToBackup(trustStoreFile);
        this.persistKeyStore(trustStoreFile, trustStore, trustPasswd);
        this.rollback.copyToBackup(new File(homeDir, "conf/server.xml"));
        this.rollback.copyToBackup(new File(homeDir, "webapps/ims/WEB-INF/classes/systemfields.properties"));
        try {
            this.kit.run(new Object[]{new File(homeDir, "utils/rsautil.cmd"), "-S", "configure-riat", "-a", "configure-ssl", "--master-password", this.kit.secret(masterPassword), "--private-key-alias", "server", "--keystore-file", idStoreFile, "--keystore-type", "JKS", "--keystore-password", this.kit.secret(idPasswd), "--truststore-file", trustStoreFile, "--truststore-type", "JKS", "--truststore-password", this.kit.secret(trustPasswd)});
        }
        catch (CommandFailedException e) {
            throw new AbortExecution(e.getMessage(), e);
        }
        this.serverTools.fixupServerConfiguration(new File(homeDir, "conf/server.xml"));
    }

    private void updateLsConfiguration(File homeDir, ServerSslConfig sslConfig, Parameters params) {
        EnumSet<LookupServiceTools.SsoRecordType> localServices;
        EnumSet<LookupServiceTools.SsoRecordType> loadBalancedServices;
        this.log.info("Updating the SSO endpoints in the Lookup Service.");
        switch (params.getNodeType()) {
            case Single: {
                loadBalancedServices = EnumSet.noneOf(LookupServiceTools.SsoRecordType.class);
                localServices = EnumSet.allOf(LookupServiceTools.SsoRecordType.class);
                this.log.info("This is Single Sign-On single-node install. All Single Sign-On endpoints are served from this node.");
                break;
            }
            case HA_Primary: {
                loadBalancedServices = EnumSet.of(LookupServiceTools.SsoRecordType.SecurityTokenService, LookupServiceTools.SsoRecordType.GroupCheckService);
                localServices = EnumSet.noneOf(LookupServiceTools.SsoRecordType.class);
                if (params.isAdminIsBehindLb()) {
                    loadBalancedServices.add(LookupServiceTools.SsoRecordType.AdminService);
                } else {
                    localServices.add(LookupServiceTools.SsoRecordType.AdminService);
                }
                this.log.info("This is Single Sign-On HA primary node. The following endpoints are served from this node: {} . The following endpoints are behind load-balancer: {}", (Object)(localServices.isEmpty() ? "none" : StringUtils.join(localServices, ", ")), (Object)StringUtils.join(loadBalancedServices, ", "));
                break;
            }
            case HA_Failover: {
                loadBalancedServices = EnumSet.of(LookupServiceTools.SsoRecordType.SecurityTokenService, LookupServiceTools.SsoRecordType.GroupCheckService);
                if (params.isAdminIsBehindLb()) {
                    loadBalancedServices.add(LookupServiceTools.SsoRecordType.AdminService);
                }
                localServices = EnumSet.noneOf(LookupServiceTools.SsoRecordType.class);
                this.log.info("This is Single Sign-On HA failover node. No endpoints are served directly from here.");
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Internal error: unexpected SsoNodeType %s (incomplete implementation?)", new Object[]{params.getNodeType()}));
            }
        }
        X509Certificate newTrustAnchor = sslConfig.getChain().get(sslConfig.getChain().size() - 1);
        this.serverTools.createLocalLsTools(homeDir).updateSsoRecords(params.getHostname(), newTrustAnchor, params.getLbHostname(), params.getLbCertificate(), localServices, loadBalancedServices);
    }

    private int undo(Exception cause, File homeDir) {
        int exitCode;
        if (cause != null) {
            String msg;
            if (cause instanceof AbortExecution) {
                exitCode = ((AbortExecution)cause).getStatusCode();
                msg = cause.getMessage();
            } else {
                exitCode = 2;
                msg = String.format("An error ocurred during the certificate replacement procedure: %s", cause.getMessage());
            }
            this.log.error(msg);
            this.log.debug("", (Throwable)cause);
            this.log.info("Undoing all changes.");
        } else {
            exitCode = 0;
        }
        this.serverTools.createLocalLsTools(homeDir).rollbackSsoRecords();
        this.rollback.restoreFile(new File(homeDir, "security/root-trust.jks"), 0);
        this.rollback.restoreFile(new File(homeDir, "security/server-identity.jks"), 0);
        this.rollback.restoreFile(new File(homeDir, "conf/server.xml"), 0);
        this.rollback.restoreFile(new File(homeDir, "webapps/ims/WEB-INF/classes/systemfields.properties"), 0);
        if (cause == null) {
            this.rollback.rollbackComplete();
            this.log.info("Restore complete.");
        }
        return exitCode;
    }

    private KeyStore createIdStore(ServerSslConfig config, String password) {
        try {
            KeyStore idStore = KeyStore.getInstance("JKS");
            idStore.load(null, null);
            List<X509Certificate> chainList = config.getChain();
            Certificate[] chain = chainList.toArray(new Certificate[chainList.size()]);
            PrivateKey key = config.getKey();
            idStore.setKeyEntry("server", key, password.toCharArray(), chain);
            return idStore;
        }
        catch (GeneralSecurityException e) {
            throw new AbortExecution(String.format(ERROR_CREATE_KEYSTORE, e.getMessage()), e);
        }
        catch (IOException e) {
            throw new AbortExecution(String.format(ERROR_CREATE_KEYSTORE, e.getMessage()), e);
        }
    }

    private KeyStore createTrustStore(ServerSslConfig config, String password) {
        try {
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null, null);
            List<X509Certificate> chainList = config.getChain();
            trustStore.setCertificateEntry("root-ca", chainList.get(chainList.size() - 1));
            return trustStore;
        }
        catch (GeneralSecurityException e) {
            throw new AbortExecution(String.format(ERROR_CREATE_KEYSTORE, e.getMessage()), e);
        }
        catch (IOException e) {
            throw new AbortExecution(String.format(ERROR_CREATE_KEYSTORE, e.getMessage()), e);
        }
    }

    private void persistKeyStore(File dest, KeyStore store, String password) {
        FileOutputStream destStr;
        dest.delete();
        try {
            destStr = new FileOutputStream(dest);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            store.store(destStr, password.toCharArray());
        }
        catch (GeneralSecurityException e) {
            throw new AbortExecution(String.format("Internal error persisting key store: %s", e.getMessage()), e);
        }
        catch (IOException e) {
            throw new AbortExecution(String.format("I/O error persisting key store to %s : %s", dest.getAbsolutePath(), e.getMessage()), e);
        }
        finally {
            IOUtils.closeQuietly(destStr);
        }
    }

    private static String randomPassword() {
        return RandomStringUtils.randomAlphanumeric(6);
    }
}

