/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadCertificateChain {
    private static final Logger executionLog = LoggerFactory.getLogger((String)"execution");
    private static final Logger log = LoggerFactory.getLogger(LoadCertificateChain.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        executionLog.info("BEGIN Load Certificate Chain");
        int statusCode = 1;
        try {
            if (args.length != 1) {
                log.error("Exactly one parameter is required (certificate chain) but {} are provided", (Object)args.length);
                statusCode = 3;
            } else {
                File fChain = new File(args[0]);
                statusCode = LoadCertificateChain.extractCertificates(fChain).isEmpty() ? 3 : 0;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            log.debug("", (Throwable)e);
            statusCode = 1;
        }
        finally {
            executionLog.info("END Load Certificate Chain");
            System.exit(statusCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static List<X509Certificate> extractCertificates(File fChain) {
        List<X509Certificate> chain;
        FileInputStream source;
        block8: {
            CertificateFactory factory = LoadCertificateChain.createCertFactory();
            source = null;
            chain = Collections.emptyList();
            try {
                source = new FileInputStream(fChain);
                chain = (List<X509Certificate>)factory.generateCertificates(source);
                log.debug("A total of {} certificates loaded from {}", (Object)chain.size(), (Object)fChain.getAbsolutePath());
                if (chain.isEmpty()) {
                    log.error("The certificate chain file is empty or does not contain a sequence of X.509 certificates.");
                    break block8;
                }
                X509Certificate root = chain.get(chain.size() - 1);
                if (!root.getSubjectX500Principal().equals(root.getIssuerX500Principal())) {
                    log.error("The last certificate in the supplied certificate chain is not a self-signed authority certificate. Append the authority certificate to the chain file.");
                    chain = Collections.emptyList();
                    break block8;
                }
                log.debug("The last certificate in the chain file is: {}", (Object)root.getSubjectX500Principal());
            }
            catch (FileNotFoundException e) {
                log.error("Certificate chain file was not found: {}", (Object)fChain.getAbsolutePath());
                log.debug("{} : {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                chain = Collections.emptyList();
                IOUtils.closeQuietly(source);
            }
            catch (CertificateException e2) {
                log.error("Certificate chain file cannot be parsed: {}", (Object)e2.getMessage());
                log.debug("", (Throwable)e2);
                chain = Collections.emptyList();
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(source);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(source);
            }
        }
        IOUtils.closeQuietly(source);
        return chain;
    }

    private static CertificateFactory createCertFactory() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            return CertificateFactory.getInstance("X.509", "BC");
        }
        catch (GeneralSecurityException e) {
            log.debug("GSE during CertificateFactory.getInstance", (Throwable)e);
            throw new IllegalStateException("Internal error: cannot create X.509 CertificateFactory. Possibly incompatible JRE or library bug.");
        }
    }
}

