/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg;

import com.vmware.sso.cfg.SsoNodeType;
import com.vmware.sso.cfg.components.ServerSslConfig;
import java.security.cert.X509Certificate;

public final class Parameters {
    public static final int FLAG_FORCE = 1;
    public static final int FLAG_ROLLBACK = 2;
    public static final int FLAG_GENERATE = 4;
    private final ServerSslConfig sslConfig;
    private final String masterPassword;
    private final SsoNodeType nodeType;
    private final String hostname;
    private final X509Certificate lbCertificate;
    private final String lbHostname;
    private final int flags;
    private final boolean adminIsBehindLb;

    public Parameters(ServerSslConfig sslConfig, String masterPassword, SsoNodeType nodeType, String hostname, X509Certificate lbCertificate, String lbHostname, boolean adminIsBehindLb, int flags) {
        this.sslConfig = sslConfig;
        this.masterPassword = masterPassword;
        this.nodeType = nodeType;
        this.hostname = hostname;
        this.lbCertificate = lbCertificate;
        this.lbHostname = lbHostname;
        this.adminIsBehindLb = adminIsBehindLb;
        this.flags = flags;
    }

    public ServerSslConfig getSslConfig() {
        return this.sslConfig;
    }

    public String getMasterPassword() {
        return this.masterPassword;
    }

    public SsoNodeType getNodeType() {
        return this.nodeType;
    }

    public String getHostname() {
        return this.hostname;
    }

    public X509Certificate getLbCertificate() {
        return this.lbCertificate;
    }

    public String getLbHostname() {
        return this.lbHostname;
    }

    public boolean isAdminIsBehindLb() {
        return this.adminIsBehindLb;
    }

    public boolean shouldForce() {
        return (this.flags & 1) != 0;
    }

    public boolean shouldRollback() {
        return (this.flags & 2) != 0;
    }

    public boolean shouldGenerate() {
        return (this.flags & 4) != 0;
    }
}

