/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg;

import com.vmware.sso.cfg.InputErrors;
import com.vmware.sso.cfg.OsDetect;
import com.vmware.sso.cfg.Parameters;
import com.vmware.sso.cfg.SsoNodeType;
import com.vmware.sso.cfg.components.IllegalSslConfigException;
import com.vmware.sso.cfg.components.ServerSslConfig;
import com.vmware.sso.cfg.components.ServerSslConfigFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.openssl.PEMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParametersLoader {
    private static final String ENV_HOSTNAME = "sso_hostname";
    private static final String ENV_CERT_CHAIN = "sso_cert_chain";
    private static final String ENV_PRIVATE_KEY = "sso_private_key";
    private static final String ENV_MASTER_PASSWORD = "sso_master_password";
    private static final String ENV_NODE_TYPE = "sso_node_type";
    private static final String ENV_ADMIN_IS_BEHIND_LB = "sso_admin_is_behind_lb";
    private static final String ENV_LB_HOSTNAME = "sso_lb_hostname";
    private static final String ENV_LB_CERTIFICATE = "sso_lb_certificate";
    private static final String ARG_FORCE = "-force";
    private static final String ARG_ROLLBACK = "-rollback";
    private static final String ARG_GENERATE = "-generate";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ServerSslConfigFactory sslConfigFactory;

    @Inject
    public ParametersLoader(ServerSslConfigFactory sslConfigFactory) {
        this.sslConfigFactory = sslConfigFactory;
    }

    public Parameters load(String[] mainargs, InputErrors errors) {
        X509Certificate lbCertificate;
        String lbHostname;
        boolean adminIsBehindLb;
        String hostname;
        SsoNodeType nodeType;
        String masterPassword;
        ServerSslConfig sslConfig;
        boolean flagRollback;
        int flags = this.argsToFlags(mainargs);
        boolean flagGenerate = (flags & 4) != 0;
        boolean bl = flagRollback = (flags & 2) != 0;
        if (flagGenerate) {
            sslConfig = null;
        } else if (!flagRollback) {
            File certificateFile = this.envParamFile(errors, ENV_CERT_CHAIN, true);
            File privateKeyFile = this.envParamFile(errors, ENV_PRIVATE_KEY, true);
            sslConfig = privateKeyFile != null && certificateFile != null ? this.loadSslConfig(errors, privateKeyFile, certificateFile) : null;
        } else {
            sslConfig = null;
        }
        if (!flagRollback) {
            masterPassword = this.envParam(errors, ENV_MASTER_PASSWORD, true);
            nodeType = this.envParamEnum(errors, ENV_NODE_TYPE, SsoNodeType.class, true);
            hostname = this.envParam(errors, ENV_HOSTNAME, false);
            Boolean adminIsBehindLbParam = this.envParamBool(errors, ENV_ADMIN_IS_BEHIND_LB, false);
            adminIsBehindLb = adminIsBehindLbParam == null ? false : adminIsBehindLbParam;
            lbHostname = this.envParam(errors, ENV_LB_HOSTNAME, false);
            lbCertificate = this.envParamCertificate(errors, ENV_LB_CERTIFICATE, false);
        } else {
            masterPassword = null;
            nodeType = null;
            hostname = null;
            adminIsBehindLb = false;
            lbHostname = null;
            lbCertificate = null;
        }
        if (!OsDetect.isWindows()) {
            errors.addError("This tool must be run on Windows. Your operating system is not supported. For updating the SSL certificates on the vCenter Server Applicance use the vpxd_servicecfg tool.");
        }
        return new Parameters(sslConfig, masterPassword, nodeType, hostname, lbCertificate, lbHostname, adminIsBehindLb, flags);
    }

    private int argsToFlags(String[] args) {
        int flags = 0;
        ArrayList<String> unrecognizedArgs = new ArrayList<String>();
        for (String arg : args = args == null ? new String[]{} : args) {
            if (ARG_FORCE.equals(arg)) {
                flags |= 1;
                continue;
            }
            if (ARG_ROLLBACK.equals(arg)) {
                flags |= 2;
                continue;
            }
            if (ARG_GENERATE.equals(arg)) {
                flags |= 4;
                continue;
            }
            unrecognizedArgs.add(arg);
        }
        if (!unrecognizedArgs.isEmpty()) {
            this.log.warn("One or more unrecognized command-line arguments ignored: {}", (Object)StringUtils.join(unrecognizedArgs, ", "));
        }
        return flags;
    }

    private String envParam(InputErrors e, String envName, boolean required) {
        String value;
        String rawValue = System.getenv(envName);
        String string = value = StringUtils.isBlank(rawValue) ? null : rawValue;
        if (value == null && required) {
            e.addError(String.format("Required environment variable %s is not set or is blank.", envName));
        }
        return value;
    }

    private Boolean envParamBool(InputErrors e, String envName, boolean required) {
        String rawValue = this.envParam(e, envName, required);
        Boolean value = rawValue != null ? Boolean.valueOf(ArrayUtils.contains(new String[]{"yes", "on", "true", "1"}, rawValue.toLowerCase())) : null;
        return value;
    }

    private File envParamFile(InputErrors e, String envName, boolean required) {
        String value = this.envParam(e, envName, required);
        return (value = StringUtils.strip(value, "\"")) == null ? null : new File(value);
    }

    private <E extends Enum<E>> E envParamEnum(InputErrors e, String envName, Class<E> enumType, boolean required) {
        String value = this.envParam(e, envName, required);
        Enum enumValue = null;
        if (value != null) {
            for (Enum ec : (Enum[])enumType.getEnumConstants()) {
                if (!ec.name().equalsIgnoreCase(value)) continue;
                enumValue = ec;
                break;
            }
            if (enumValue == null) {
                String validValues = StringUtils.join((Object[])enumType.getEnumConstants(), ", ");
                e.addError(String.format("Environment variable %s contains an unrecognized value: %s . The valid values are: %s .", envName, value, validValues));
            }
        } else {
            enumValue = null;
        }
        return (E)enumValue;
    }

    private ServerSslConfig loadSslConfig(InputErrors e, File privateKeyFile, File certificateFile) {
        try {
            return this.sslConfigFactory.load(privateKeyFile, certificateFile);
        }
        catch (IllegalSslConfigException ex) {
            e.addError(ex.getMessage());
            this.log.debug("", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate envParamCertificate(InputErrors e, String envName, boolean required) {
        X509Certificate cert;
        String certFile = this.envParam(e, envName, required);
        Object certObj = null;
        if (certFile != null) {
            try {
                PEMReader reader = new PEMReader((Reader)new FileReader(new File(certFile)));
                try {
                    certObj = reader.readObject();
                    cert = (X509Certificate)certObj;
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            catch (IOException ex) {
                cert = null;
                e.addError(String.format("The file %s (parameter %s) cannot be read: %s", certFile, envName, ex.getMessage()));
                this.log.debug(ex.getMessage(), (Object)e);
            }
            catch (ClassCastException ex) {
                cert = null;
                String foundType = certObj == null ? "nothing" : String.format("object of type %s", certObj.getClass().getName());
                String msg = String.format("File %s does not contain a PEM-encoded X.509 certificate (found %s)", certFile, foundType);
                e.addError(msg);
            }
        } else {
            cert = null;
        }
        return cert;
    }
}

