/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg.components;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import java.io.File;
import java.io.IOException;

public final class Files {
    private static final Kernel32 kernel32 = Kernel32.INSTANCE;

    public static void copy(File source, File target) throws IOException {
        if (!kernel32.CopyFile(Files.uncPath(source), Files.uncPath(target), false)) {
            throw new IOException("CopyFile error: " + Kernel32Util.formatMessageFromLastErrorCode((int)kernel32.GetLastError()));
        }
    }

    public static void move(File source, File target) throws IOException {
        boolean success = kernel32.MoveFileEx(Files.uncPath(source), Files.uncPath(target), new WinDef.DWORD(11L));
        if (!success) {
            throw new IOException("MoveFileEx error: " + Kernel32Util.formatMessageFromLastErrorCode((int)kernel32.GetLastError()));
        }
    }

    private static String uncPath(File file) {
        return "\\\\?\\" + file.getAbsolutePath();
    }
}

