/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg.components.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import javax.inject.Provider;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.openssl.PEMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemTrustStoreLinux
implements Provider<KeyStore> {
    private static final String ERROR_KEYSTORE_CREATE = "Internal error: cannot create in-memroy key store. Possibly incompatible Java platform.";
    private static final String ERROR_KEYSTORE_OP = "Internal error during operation with in-memory key store.";
    private static final File CA_PATH = new File("/etc/ssl/certs");
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public KeyStore get() {
        KeyStore store;
        this.log.debug("Loading system-wide trust store.");
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".pem");
            }
        };
        try {
            store = KeyStore.getInstance("JKS");
            store.load(null, null);
        }
        catch (GeneralSecurityException e) {
            this.log.error(ERROR_KEYSTORE_CREATE, (Throwable)e);
            throw new IllegalStateException(ERROR_KEYSTORE_CREATE, e);
        }
        catch (IOException e) {
            this.log.error(ERROR_KEYSTORE_CREATE, (Throwable)e);
            throw new IllegalStateException(ERROR_KEYSTORE_CREATE, e);
        }
        try {
            for (File certFile : CA_PATH.listFiles(filter)) {
                X509Certificate cert = this.loadCertificate(certFile);
                if (cert == null) continue;
                store.setCertificateEntry(cert.getSubjectX500Principal().toString(), cert);
            }
        }
        catch (KeyStoreException e) {
            this.log.error(ERROR_KEYSTORE_OP, (Throwable)e);
            throw new IllegalStateException(ERROR_KEYSTORE_OP, e);
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private X509Certificate loadCertificate(File certFile) {
        X509Certificate x509Certificate;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(certFile));
            x509Certificate = (X509Certificate)new PEMReader((Reader)reader).readObject();
        }
        catch (IOException e) {
            this.log.debug("Exception reading certificate file `{}': {} : {}. File ignored.", new Object[]{certFile.getAbsolutePath(), e.getClass().getName(), e.getMessage()});
            X509Certificate x509Certificate2 = null;
            IOUtils.closeQuietly(reader);
            return x509Certificate2;
        }
        catch (ClassCastException e2) {
            this.log.debug("No valid certificate found in certificate file `{}': {}. File ignored.", (Object)certFile.getAbsolutePath(), (Object)e2.getMessage());
            X509Certificate x509Certificate3 = null;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(reader);
            return x509Certificate3;
        }
        IOUtils.closeQuietly(reader);
        return x509Certificate;
    }
}

