/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.SessionManager;
import com.vmware.vim.binding.sso.admin.CertificateManager;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.DeploymentInformationService;
import com.vmware.vim.binding.sso.admin.DomainManagementService;
import com.vmware.vim.binding.sso.admin.LockoutPolicyService;
import com.vmware.vim.binding.sso.admin.PasswordPolicyService;
import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vim.binding.sso.admin.PrincipalManagementService;
import com.vmware.vim.binding.sso.admin.ReplicationService;
import com.vmware.vim.binding.sso.admin.RoleManagementService;
import com.vmware.vim.binding.sso.admin.ServiceContent;
import com.vmware.vim.binding.sso.admin.ServiceInstance;
import com.vmware.vim.binding.sso.admin.SmtpManagementService;
import com.vmware.vim.binding.sso.fault.RuntimeServiceFault;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.admin.DeploymentInformation;
import com.vmware.vim.sso.admin.DomainManagement;
import com.vmware.vim.sso.admin.LockoutPolicyConfigurator;
import com.vmware.vim.sso.admin.PasswordPolicyConfigurator;
import com.vmware.vim.sso.admin.PrincipalDiscovery;
import com.vmware.vim.sso.admin.PrincipalManagement;
import com.vmware.vim.sso.admin.PrincipalSelfManagement;
import com.vmware.vim.sso.admin.Replication;
import com.vmware.vim.sso.admin.RoleManagement;
import com.vmware.vim.sso.admin.ServerConfigurator;
import com.vmware.vim.sso.admin.SmtpConfigurator;
import com.vmware.vim.sso.admin.client.AdminClient;
import com.vmware.vim.sso.admin.client.ClientConfiguration;
import com.vmware.vim.sso.admin.client.vmomi.impl.AbstractClient;
import com.vmware.vim.sso.admin.client.vmomi.impl.CertificateManagementImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.DeploymentInformationImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.DomainManagementImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.LockoutPolicyConfiguratorImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.PasswordPolicyConfiguratorImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.PrincipalDiscoveryImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.PrincipalManagementImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.PrincipalSelfManagementImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.ReplicationImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.RoleManagementImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.ServerConfiguratorImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.SmtpConfiguratorImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AdminClientImpl
extends AbstractClient
implements AdminClient {
    private static final String SERVICE_NAME = "SsoAdminServiceInstance";
    private static final String CREATE_SUCCESS_MSG = "Client was created successfully";
    private final Client _client;
    private final ServerConfigurator _serverConfigurator;
    private final PrincipalManagement _principalManagement;
    private final PrincipalSelfManagement _principalSelfManagement;
    private final PrincipalDiscovery _principalDiscovery;
    private final RoleManagement _roleManagement;
    private final SmtpConfigurator _smtpConfigurator;
    private final PasswordPolicyConfigurator _passPolicyConfigurator;
    private final LockoutPolicyConfigurator _lockoutConfigurator;
    private final DomainManagement _domainManagement;
    private final DeploymentInformation _deploymentInformation;
    private final Replication _replication;
    private final SessionManager _sessionManager;
    private final Log _log = LogFactory.getLog(AdminClientImpl.class);

    public AdminClientImpl(Client client, ClientConfiguration.AuthenticationData authData) throws SystemException {
        CertificateManagementImpl certificateManagement;
        assert (client != null);
        this._client = client;
        ServiceContent serviceContent = this.createServiceContent();
        this._sessionManager = (SessionManager)this._client.createStub(SessionManager.class, serviceContent.getSessionManager());
        if (authData != null) {
            this.login(authData);
        }
        this._serverConfigurator = new ServerConfiguratorImpl((ConfigurationManagementService)this._client.createStub(ConfigurationManagementService.class, serviceContent.getConfigurationManagementService()));
        PrincipalManagementService vmomiPrincipalMgmt = (PrincipalManagementService)this._client.createStub(PrincipalManagementService.class, serviceContent.getPrincipalManagementService());
        this._principalManagement = new PrincipalManagementImpl(vmomiPrincipalMgmt);
        this._principalSelfManagement = new PrincipalSelfManagementImpl(vmomiPrincipalMgmt);
        this._principalDiscovery = new PrincipalDiscoveryImpl((PrincipalDiscoveryService)this._client.createStub(PrincipalDiscoveryService.class, serviceContent.getPrincipalDiscoveryService()));
        this._roleManagement = new RoleManagementImpl((RoleManagementService)this._client.createStub(RoleManagementService.class, serviceContent.getRoleManagementService()));
        this._smtpConfigurator = new SmtpConfiguratorImpl((SmtpManagementService)this._client.createStub(SmtpManagementService.class, serviceContent.getSmtpManagementService()));
        this._passPolicyConfigurator = new PasswordPolicyConfiguratorImpl((PasswordPolicyService)this._client.createStub(PasswordPolicyService.class, serviceContent.getPasswordPolicyService()));
        this._lockoutConfigurator = new LockoutPolicyConfiguratorImpl((LockoutPolicyService)this._client.createStub(LockoutPolicyService.class, serviceContent.getLockoutPolicyService()));
        DomainManagementService vmodlDomainMgmt = (DomainManagementService)this._client.createStub(DomainManagementService.class, serviceContent.getDomainManagementService());
        try {
            certificateManagement = new CertificateManagementImpl((CertificateManager)this._client.createStub(CertificateManager.class, vmodlDomainMgmt.getSslCertificateManager()));
        }
        catch (RuntimeServiceFault e) {
            throw new IllegalStateException("Cannot retrieve service content", e);
        }
        this._domainManagement = new DomainManagementImpl(vmodlDomainMgmt, certificateManagement);
        this._deploymentInformation = new DeploymentInformationImpl((DeploymentInformationService)this._client.createStub(DeploymentInformationService.class, serviceContent.getDeploymentInformationService()));
        this._replication = new ReplicationImpl((ReplicationService)this._client.createStub(ReplicationService.class, serviceContent.getReplicationService()));
        this.populateAboutInfo(serviceContent.getAboutInfo());
        this._log.info((Object)CREATE_SUCCESS_MSG);
    }

    @Override
    public PrincipalManagement getPrincipalManagement() {
        return this._principalManagement;
    }

    @Override
    public PrincipalSelfManagement getPrincipalSelfManagement() {
        return this._principalSelfManagement;
    }

    @Override
    public PrincipalDiscovery getPrincipalDiscovery() {
        return this._principalDiscovery;
    }

    @Override
    public ServerConfigurator getServerConfigurator() {
        return this._serverConfigurator;
    }

    @Override
    public RoleManagement getRoleManagement() {
        return this._roleManagement;
    }

    @Override
    public SmtpConfigurator getSmtpConfigurator() {
        return this._smtpConfigurator;
    }

    @Override
    public PasswordPolicyConfigurator getPasswordPolicyConfigurator() {
        return this._passPolicyConfigurator;
    }

    @Override
    public LockoutPolicyConfigurator getLockoutPolicyConfigurator() {
        return this._lockoutConfigurator;
    }

    @Override
    public DomainManagement getDomainManagement() {
        return this._domainManagement;
    }

    @Override
    public DeploymentInformation getDeploymentInformation() {
        return this._deploymentInformation;
    }

    @Override
    public Replication getReplication() {
        return this._replication;
    }

    @Override
    protected SessionManager getSessionManager() {
        return this._sessionManager;
    }

    @Override
    protected void shutdownClient() {
        this._client.shutdown();
    }

    private ServiceContent createServiceContent() throws SystemException {
        VmodlType type = VmodlTypeMap.Factory.getTypeMap().getVmodlType(ServiceInstance.class);
        assert (type != null);
        ManagedObjectReference moRef = new ManagedObjectReference();
        moRef.setType(type.getWsdlName());
        moRef.setValue(SERVICE_NAME);
        final ServiceInstance serviceInstance = (ServiceInstance)this._client.createStub(ServiceInstance.class, moRef);
        return (ServiceContent)new VmomiClientCommand<ServiceContent>(){

            @Override
            public ServiceContent actionCommand() throws ServiceFault, SystemException {
                return serviceInstance.retrieveServiceContent();
            }
        }.executeEnsuringNoDomainError();
    }
}

