/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.SessionManager;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.binding.sso.groupcheck.GroupCheckService;
import com.vmware.vim.binding.sso.groupcheck.ServiceContent;
import com.vmware.vim.binding.sso.groupcheck.ServiceInstance;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.admin.GroupChecker;
import com.vmware.vim.sso.admin.client.ClientConfiguration;
import com.vmware.vim.sso.admin.client.GroupCheckClient;
import com.vmware.vim.sso.admin.client.vmomi.impl.AbstractClient;
import com.vmware.vim.sso.admin.client.vmomi.impl.GroupCheckerImpl;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GroupCheckClientImpl
extends AbstractClient
implements GroupCheckClient {
    private static final String SERVICE_NAME = "ServiceInstance";
    private static final String CREATE_SUCCESS_MSG = "Client was created successfully";
    private final Client _client;
    private final SessionManager _sessionManager;
    private final GroupCheckService _groupCheckService;
    private final Log _log = LogFactory.getLog(GroupCheckClientImpl.class);

    public GroupCheckClientImpl(Client client, ClientConfiguration.AuthenticationData authData) throws SystemException {
        assert (client != null);
        assert (authData != null);
        this._client = client;
        ServiceContent serviceContent = this.createServiceContent();
        this._sessionManager = (SessionManager)this._client.createStub(SessionManager.class, serviceContent.getSessionManager());
        this.login(authData);
        this._groupCheckService = (GroupCheckService)this._client.createStub(GroupCheckService.class, serviceContent.getGroupCheckService());
        this.populateAboutInfo(serviceContent.getAboutInfo());
        this._log.info((Object)CREATE_SUCCESS_MSG);
    }

    @Override
    public GroupChecker getGroupChecker() {
        return new GroupCheckerImpl(this._groupCheckService);
    }

    @Override
    protected SessionManager getSessionManager() {
        return this._sessionManager;
    }

    @Override
    protected void shutdownClient() {
        this._client.shutdown();
    }

    private ServiceContent createServiceContent() throws SystemException {
        VmodlType type = VmodlTypeMap.Factory.getTypeMap().getVmodlType(ServiceInstance.class);
        assert (type != null);
        ManagedObjectReference moRef = new ManagedObjectReference();
        moRef.setType(type.getWsdlName());
        moRef.setValue(SERVICE_NAME);
        final ServiceInstance serviceInstance = (ServiceInstance)this._client.createStub(ServiceInstance.class, moRef);
        return (ServiceContent)new VmomiClientCommand<ServiceContent>(){

            @Override
            public ServiceContent actionCommand() throws ServiceFault, SystemException {
                return serviceInstance.retrieveServiceContent();
            }
        }.executeEnsuringNoDomainError();
    }
}

