/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.binding.sso.groupcheck.GroupCheckService;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.GroupChecker;
import com.vmware.vim.sso.admin.client.vmomi.impl.SdkVmodlTypeConversions;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;
import java.util.Set;

final class GroupCheckerImpl
implements GroupChecker {
    private final GroupCheckService _groupCheckService;

    public GroupCheckerImpl(GroupCheckService groupCheckService) {
        assert (groupCheckService != null);
        this._groupCheckService = groupCheckService;
    }

    public Set<PrincipalId> findAllParentGroups(final PrincipalId userId) throws InvalidPrincipalException, SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)userId, (String)"Principal Id");
        return (Set)new VmomiClientCommand<Set<PrincipalId>>(){

            @Override
            public Set<PrincipalId> actionCommand() throws ServiceFault, SystemException {
                return SdkVmodlTypeConversions.fromVmodl(GroupCheckerImpl.this._groupCheckService.findAllParentGroups(VmodlTypeConversions.toVmodl((PrincipalId)userId)));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public Set<PrincipalId> findParentGroups(final PrincipalId userId, final Set<PrincipalId> groupList) throws InvalidPrincipalException, SystemException, NotAuthenticatedException {
        return (Set)new VmomiClientCommand<Set<PrincipalId>>(){

            @Override
            public Set<PrincipalId> actionCommand() throws ServiceFault, SystemException {
                return SdkVmodlTypeConversions.fromVmodl(GroupCheckerImpl.this._groupCheckService.findParentGroups(VmodlTypeConversions.toVmodl((PrincipalId)userId), SdkVmodlTypeConversions.toVmodl(groupList)));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean isMemberOfGroup(final PrincipalId userId, final PrincipalId groupId) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)userId, (String)"Principal Id");
        ValidateUtil.validateNotNull((Object)groupId, (String)"Group Id");
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return GroupCheckerImpl.this._groupCheckService.isMemberOfGroup(VmodlTypeConversions.toVmodl((PrincipalId)userId), VmodlTypeConversions.toVmodl((PrincipalId)groupId));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }
}

