/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.SmtpManagementService;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.sso.admin.MailContent;
import com.vmware.vim.sso.admin.SmtpConfig;
import com.vmware.vim.sso.admin.SmtpConfigurator;
import com.vmware.vim.sso.admin.client.vmomi.impl.SdkVmodlTypeConversions;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SmtpConfigNotSetException;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;

final class SmtpConfiguratorImpl
implements SmtpConfigurator {
    private final SmtpManagementService _vmomiService;

    public SmtpConfiguratorImpl(SmtpManagementService vmomiService) {
        assert (vmomiService != null);
        this._vmomiService = vmomiService;
    }

    public SmtpConfig getSMTPConfiguration() throws SystemException, SmtpConfigNotSetException, NotAuthenticatedException {
        return (SmtpConfig)new VmomiClientCommand<SmtpConfig>(){

            @Override
            public SmtpConfig actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.SmtpConfig)SmtpConfiguratorImpl.this._vmomiService.getSmtpConfiguration());
            }
        }.executeEnsuringDomainErrorIs(SmtpConfigNotSetException.class, NotAuthenticatedException.class);
    }

    public void sendMail(final MailContent mail) throws SystemException, SmtpConfigNotSetException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)mail, (String)"Mail content");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                SmtpConfiguratorImpl.this._vmomiService.sendMail(SdkVmodlTypeConversions.toVmodl(mail));
                return null;
            }
        }.executeEnsuringDomainErrorIs(SmtpConfigNotSetException.class, NotAuthenticatedException.class);
    }

    public void updateSMTPConfiguration(final SmtpConfig config) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)config, (String)"SMTP config");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                SmtpConfiguratorImpl.this._vmomiService.updateSmtpConfiguration(VmodlTypeConversions.toVmodl((SmtpConfig)config));
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }
}

