/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.planner;

import com.vmware.sso.planner.Service;
import com.vmware.sso.planner.Step;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepsPlanner {
    public static final int ERROR_INVALID_ARGUMENT = 3;
    private static final String INPUT_DELIMITER = ",";
    private static final Logger log = LoggerFactory.getLogger(StepsPlanner.class);
    private static Map<Service, List<Step>> servicesSteps = new HashMap<Service, List<Step>>();

    public static int executeCommand(String args) {
        assert (args != null);
        Plan plan = StepsPlanner.createSteps(args);
        ArrayList<String> serviceFriendlyNames = new ArrayList<String>();
        for (Service service : plan.affectedService) {
            serviceFriendlyNames.add(service.toString());
        }
        log.info("");
        log.info("Selected services: {}", (Object)StringUtils.join(!serviceFriendlyNames.isEmpty() ? serviceFriendlyNames : Arrays.asList(Service.values()), ", "));
        log.info("Detailed Plan to follow:");
        log.info("");
        for (int i = 0; i < plan.steps.size(); ++i) {
            log.info(i + 1 + ". " + plan.steps.get(i));
            log.info("");
        }
        return 0;
    }

    public static Plan createSteps(String servicesToUpdate) throws IllegalArgumentException {
        assert (servicesToUpdate != null);
        StringTokenizer servicesNames = new StringTokenizer(servicesToUpdate, INPUT_DELIMITER);
        ArrayList<Service> affectedServices = new ArrayList<Service>();
        ArrayList<Step> stepsToExecute = new ArrayList<Step>();
        ArrayList<String> invalidIds = new ArrayList<String>();
        while (servicesNames.hasMoreTokens()) {
            int serviceNum;
            String serviceNumStr = servicesNames.nextToken().trim();
            try {
                serviceNum = Integer.parseInt(serviceNumStr);
            }
            catch (NumberFormatException e) {
                invalidIds.add(serviceNumStr);
                continue;
            }
            Service[] allServices = Service.values();
            int serviceInd = serviceNum - 1;
            if (serviceInd >= allServices.length || serviceInd < 0) {
                if (serviceInd != allServices.length) {
                    invalidIds.add(Integer.toString(serviceInd + 1));
                    continue;
                }
                assert (serviceInd == allServices.length);
                for (Service service : servicesSteps.keySet()) {
                    StepsPlanner.addStepsToExecutePerService(stepsToExecute, service);
                }
                continue;
            }
            Service currentService = allServices[serviceInd];
            affectedServices.add(currentService);
            log.info("Input service number: {}, name: {}", (Object)serviceNum, (Object)currentService.toString());
            StepsPlanner.addStepsToExecutePerService(stepsToExecute, currentService);
        }
        if (!invalidIds.isEmpty()) {
            throw new IllegalArgumentException("One or more invalid entries were supplied: " + StringUtils.join(invalidIds, ", "));
        }
        Collections.sort(stepsToExecute);
        return new Plan(affectedServices, stepsToExecute);
    }

    private static void addStepsToExecutePerService(List<Step> stepsToExecute, Service service) {
        List<Step> stepsPerService = servicesSteps.get((Object)service);
        for (Step step : stepsPerService) {
            if (stepsToExecute.contains(step)) continue;
            stepsToExecute.add(step);
        }
    }

    static {
        servicesSteps.put(Service.SSO, Arrays.asList(Step.SSO, Step.IS_SSO, Step.VC_SSO, Step.VCO_SSO, Step.NGC_SSO, Step.LOG_BROWSER_SSO));
        servicesSteps.put(Service.IS, Arrays.asList(Step.IS, Step.VC_IS, Step.NGC_IS));
        servicesSteps.put(Service.VC, Arrays.asList(Step.VC, Step.VC_IS, Step.VCO_VC, Step.VUM_VC, Step.NGC_VC, Step.IS_VC));
        servicesSteps.put(Service.VCO, Arrays.asList(Step.VCO));
        servicesSteps.put(Service.NGC, Arrays.asList(Step.NGC));
        servicesSteps.put(Service.LOG_BROWSER, Arrays.asList(Step.LOG_BROWSER));
        servicesSteps.put(Service.VUM, Arrays.asList(Step.VUM));
    }

    private static class Plan {
        final List<Service> affectedService;
        final List<Step> steps;

        public Plan(List<Service> affectedService, List<Step> steps) {
            this.affectedService = affectedService;
            this.steps = steps;
        }
    }
}

