/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl;

import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.exception.CertificateValidationException;
import com.vmware.vim.sso.client.exception.ServerCommunicationException;
import com.vmware.vim.sso.client.impl.SoapBinding;
import com.vmware.vim.sso.client.impl.SoapFault;
import com.vmware.vim.sso.client.impl.SoapMessage;
import com.vmware.vim.sso.client.impl.ValidateUtil;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import com.vmware.vim.sso.client.impl.exception.SoapFaultException;
import com.vmware.vim.sso.client.impl.ssl.InetAddressUtils;
import com.vmware.vim.sso.client.impl.ssl.StsSslTrustManager;
import com.vmware.vim.sso.client.impl.ssl.UntrustedSslCertificateException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.ws.spi.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SoapBindingImpl
implements SoapBinding {
    private static final String WS_TRUST_NAMESPACE_WSDL = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/wsdl";
    private static final String STS_SERVICE = "STSService";
    private static final String STS_SERVICE_PORT = "STSService_Port";
    private static final String WS_OVER_SSL_RESOURCE = "com/vmware/vim/sso/client/impl/ssl/ws_over_ssl.properties";
    private static final QName serviceName = new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512/wsdl", "STSService");
    private static final QName portName = new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512/wsdl", "STSService_Port");
    private static final Log _log = LogFactory.getLog(SoapBindingImpl.class);
    private static final String SSL_SOCKET_FACTORY_KEY = SoapBindingImpl.getSslSocketFactoryProperty();
    private final SecurityTokenServiceConfig.ConnectionConfig _connConfig;

    public SoapBindingImpl(SecurityTokenServiceConfig.ConnectionConfig connConfig) {
        assert (connConfig != null);
        this._connConfig = connConfig;
    }

    @Override
    public SoapMessage sendMessage(SoapMessage message) throws ServerCommunicationException, ParserException, SoapFaultException, CertificateValidationException {
        Dispatch<SOAPMessage> dispatch = this.createDispatch(message.getSoapAction());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Sending SOAP request to the STS server");
        }
        SOAPMessage response = this.sendMessage(dispatch, message.getMessage());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Received SOAP response from the STS server");
        }
        return new SoapMessage(response, message.getSoapAction());
    }

    private Dispatch<SOAPMessage> createDispatch(String soapAction) throws ServerCommunicationException {
        Service service = Service.create((QName)serviceName);
        service.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", this._connConfig.getUrl().toString());
        Dispatch dispatch = null;
        try {
            dispatch = service.createDispatch(portName, SOAPMessage.class, Service.Mode.MESSAGE);
        }
        catch (WebServiceException e) {
            String errMsg = "Error communicating to the remote server " + this._connConfig.getUrl();
            _log.error((Object)errMsg, (Throwable)e);
            throw new ServerCommunicationException(errMsg, e);
        }
        this.setSoapAction((Dispatch<SOAPMessage>)dispatch, soapAction);
        this.establishSslTrust((BindingProvider)dispatch, new TrustManager[]{new StsSslTrustManager(this._connConfig)});
        return dispatch;
    }

    private void setSoapAction(Dispatch<SOAPMessage> dispatch, String soapAction) {
        Map requestContext = dispatch.getRequestContext();
        requestContext.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
        requestContext.put("javax.xml.ws.soap.http.soapaction.uri", soapAction);
    }

    private SOAPMessage sendMessage(Dispatch<SOAPMessage> dispatch, SOAPMessage request) throws SoapFaultException, ServerCommunicationException, CertificateValidationException {
        try {
            return (SOAPMessage)dispatch.invoke((Object)request);
        }
        catch (SOAPFaultException e) {
            _log.error((Object)"SOAP fault", (Throwable)e);
            throw new SoapFaultException("", new SoapFault(e.getFault()));
        }
        catch (WebServiceException e) {
            SSLHandshakeException ex;
            if (e.getCause() instanceof SSLHandshakeException && (ex = (SSLHandshakeException)e.getCause()).getCause() instanceof UntrustedSslCertificateException) {
                this.logAndThrow((UntrustedSslCertificateException)ex.getCause());
            }
            String errMsg = "Error communicating to the remote server " + this._connConfig.getUrl();
            _log.error((Object)errMsg, (Throwable)e);
            throw new ServerCommunicationException(errMsg, e);
        }
    }

    private void establishSslTrust(BindingProvider bindingProvider, TrustManager[] sslTrust) {
        assert (!ValidateUtil.isEmpty(sslTrust));
        SSLSocketFactory socketFactory = null;
        try {
            SSLContext sslCtx = SSLContext.getInstance("SSL");
            sslCtx.init(null, sslTrust, null);
            socketFactory = sslCtx.getSocketFactory();
        }
        catch (Exception e) {
            String errMsg = "Cannot create default SSL socket factory";
            _log.fatal((Object)errMsg, (Throwable)e);
            throw new IllegalStateException(errMsg, e);
        }
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put(SSL_SOCKET_FACTORY_KEY, socketFactory);
        if (this.isSTSContactedByIPAddress()) {
            _log.info((Object)"Overriding host name verifier as the STS is contacted by IP address");
            String j2seHostNameVerifierKey = "com.sun.xml.internal.ws.transport.https.client.hostname.verifier";
            requestContext.put("com.sun.xml.internal.ws.transport.https.client.hostname.verifier", new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    String peerHost;
                    boolean result = (urlHostName = SoapBindingImpl.normalizeIp(urlHostName)).equals(peerHost = SoapBindingImpl.normalizeIp(session.getPeerHost()));
                    if (!result) {
                        _log.warn((Object)("Warning: URL Host: " + urlHostName + " <> " + session.getPeerHost()));
                    }
                    return result;
                }
            });
        }
    }

    private static String normalizeIp(String ip) {
        try {
            ip = InetAddress.getByName(ip).getHostAddress();
        }
        catch (UnknownHostException e) {
            _log.warn((Object)("Failed to normalize IP: " + ip));
        }
        return ip;
    }

    private static String getSslSocketFactoryProperty() {
        Log log = LogFactory.getLog(SoapBindingImpl.class);
        String wsProviderClass = Provider.provider().getClass().getName();
        InputStream is = null;
        try {
            is = SoapBindingImpl.class.getClassLoader().getResourceAsStream(WS_OVER_SSL_RESOURCE);
            Properties resource = new Properties();
            resource.load(is);
            String socketFactoryProperty = resource.getProperty(wsProviderClass);
            if (socketFactoryProperty == null) {
                log.warn((Object)String.format("SSO client cannot connect to STS over SSL because WS provider '%s' is NOT configured.", wsProviderClass));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("WS provider '%s' configured with SSL. Socket factory property is '%s'", wsProviderClass, socketFactoryProperty));
            }
            String string = socketFactoryProperty;
            return string;
        }
        catch (IOException e) {
            String message = "Cannot load WS over SSL resource file";
            log.fatal((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void logAndThrow(UntrustedSslCertificateException e) throws CertificateValidationException {
        _log.error((Object)e.getMessage(), (Throwable)e);
        throw new CertificateValidationException(e.getMessage(), e.getServerCertificateChain(), e.getServerCertificateThumbprint());
    }

    private boolean isSTSContactedByIPAddress() {
        String sts = this._connConfig.getUrl().getHost();
        if (sts.startsWith("[") && sts.endsWith("]")) {
            sts = sts.substring(1, sts.length() - 1);
        }
        return InetAddressUtils.isIPv4Address(sts) || InetAddressUtils.isIPv6Address(sts);
    }
}

