/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.o11n.tools.certs;

import com.vmware.o11n.tools.certs.VCOSSLKeysChangeHelper;
import com.vmware.o11n.tools.certs.VCOServerFileSystemHelper;
import com.vmware.o11n.tools.certs.VCOTrustStoreImportHelper;
import java.io.File;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCOCertificateUpdate {
    private static final Logger log = LoggerFactory.getLogger(VCOCertificateUpdate.class);

    public static void main(String ... args) {
        File privateKey;
        boolean back;
        VCOSSLKeysChangeHelper sslhelper;
        boolean sameCert;
        File certificate;
        String backupFolder;
        VCOServerFileSystemHelper fshelper;
        File keyStoreFileName;
        Security.addProvider(new BouncyCastleProvider());
        if (args.length == 0 || args.length > 2) {
            log.error("Wrong number of command line parameters");
            System.exit(3);
        }
        if ((keyStoreFileName = (fshelper = new VCOServerFileSystemHelper()).getLocalFile("9f0b620c-1ee4-11b2-9710-b2a4ea0a4eb7")) == null || !keyStoreFileName.exists()) {
            log.error("Unable to find vCO installation");
            System.exit(2);
        }
        if ((backupFolder = System.getenv("ROLLBACK_BACKUP_FOLDER")) == null || backupFolder.length() == 0) {
            log.warn("The following environment variable is not set: ROLLBACK_BACKUP_FOLDER");
            backupFolder = keyStoreFileName.getParent();
        }
        if ("-rollback".equals(args[0])) {
            boolean rollback = fshelper.restore(keyStoreFileName, new File(backupFolder));
            if (rollback) {
                log.info("Rolling back previous changes");
                System.exit(0);
                log.info("Done.");
            }
            log.error("Cannot restore the certificate from folder: " + backupFolder);
            System.exit(201);
        }
        if (!(certificate = new File(args[0])).exists()) {
            log.error("Public certificate file does not exist");
            System.exit(3);
        }
        VCOTrustStoreImportHelper helper = new VCOTrustStoreImportHelper();
        if (args.length == 1) {
            log.info("Importing the certificate");
            Boolean ok = helper.importCertificates(certificate, keyStoreFileName);
            if (Boolean.FALSE.equals(ok)) {
                log.error("Unable to import the certificate");
                System.exit(1);
            }
            System.exit(0);
            log.info("Done.");
        }
        if (sameCert = (sslhelper = new VCOSSLKeysChangeHelper()).checkSSLKeyPairExists(certificate)) {
            // empty if block
        }
        if (!(back = fshelper.backup(keyStoreFileName, new File(backupFolder)))) {
            log.error("Cannot backup the certificate to folder: " + backupFolder);
            System.exit(200);
        }
        if (!(privateKey = new File(args[1])).exists()) {
            log.error("Private key file does not exist");
            System.exit(3);
        }
        log.info("Changing SSL certificate");
        boolean ok = sslhelper.changeSSLKeyPair(certificate, privateKey, keyStoreFileName);
        if (!ok) {
            log.error("Unable to change the SSL keys");
            System.exit(1);
        }
        System.exit(0);
        log.info("Done.");
    }
}

