/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.o11n.tools.certs;

import com.vmware.o11n.tools.certs.VCOServerFileSystemHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.openssl.PEMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCOTrustStoreImportHelper {
    private Logger log = LoggerFactory.getLogger(VCOTrustStoreImportHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Certificate[] getCertificates(File input) throws IOException {
        FileInputStream certificateStream = null;
        InputStreamReader certificateReader = null;
        try {
            Certificate[] certificates;
            certificateStream = new FileInputStream(input);
            CertificateFactory fac = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> res = fac.generateCertificates(certificateStream);
            Certificate[] certificateArray = certificates = res.toArray(new Certificate[res.size()]);
            return certificateArray;
        }
        catch (Exception e) {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            certificateReader = new FileReader(input);
            PEMReader pemReader = new PEMReader(certificateReader);
            try {
                Object o = null;
                while ((o = pemReader.readObject()) != null) {
                    if (!(o instanceof X509Certificate)) {
                        throw new IOException("Read " + o.getClass().getName() + " instead of X509Certificate");
                    }
                    certs.add((X509Certificate)o);
                }
            }
            finally {
                pemReader.close();
            }
            Certificate[] certificateArray = certs.toArray(new Certificate[certs.size()]);
            return certificateArray;
        }
        finally {
            if (certificateStream != null) {
                certificateStream.close();
            }
            if (certificateReader != null) {
                certificateReader.close();
            }
        }
    }

    public Boolean importCertificates(File publicChainDer, File keyStoreFile) {
        try {
            String rootAlias;
            Certificate[] certificates = this.getCertificates(publicChainDer);
            KeyStore keyStore = KeyStore.getInstance("jks");
            FileInputStream jssecacertsInputStream = new FileInputStream(keyStoreFile);
            keyStore.load(jssecacertsInputStream, "dunesdunes".toCharArray());
            jssecacertsInputStream.close();
            boolean atLeastSomethingImported = false;
            String currentAlias = rootAlias = "ssl:_imported_";
            int dunesIndex = 1;
            for (Certificate cer : certificates) {
                while (keyStore.getCertificate(currentAlias) != null) {
                    currentAlias = rootAlias + "_" + dunesIndex;
                    ++dunesIndex;
                }
                String aliasExsting = keyStore.getCertificateAlias(cer);
                if (aliasExsting != null) continue;
                keyStore.setCertificateEntry(currentAlias, cer);
                atLeastSomethingImported = true;
            }
            if (!atLeastSomethingImported) {
                this.log.warn("The certificates to import already exist.");
                return null;
            }
            File tmpFile = new File(keyStoreFile.getAbsolutePath() + ".tmp");
            FileOutputStream fos = new FileOutputStream(tmpFile);
            keyStore.store(fos, "dunesdunes".toCharArray());
            fos.close();
            keyStoreFile.delete();
            tmpFile.renameTo(keyStoreFile);
            return true;
        }
        catch (Exception e) {
            this.log.error("Cannot import certificate. ", e);
            return false;
        }
    }

    public Boolean importCertificates(File publicChainDer) {
        VCOServerFileSystemHelper helper = new VCOServerFileSystemHelper();
        File keyStoreFileName = helper.getLocalFile("9f0b620c-1ee4-11b2-9710-b2a4ea0a4eb7");
        return this.importCertificates(publicChainDer, keyStoreFileName);
    }
}

