/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.common.impl;

import com.vmware.vim.vmomi.client.common.impl.EnvelopeStackContext;
import com.vmware.vim.vmomi.client.common.impl.HeaderParamContext;
import com.vmware.vim.vmomi.client.common.impl.HeaderStackContext;
import com.vmware.vim.vmomi.client.common.impl.ReturnvalStackContext;
import com.vmware.vim.vmomi.client.common.impl.SoapFaultStackContext;
import com.vmware.vim.vmomi.client.common.impl.StackContext;
import com.vmware.vim.vmomi.core.ResponseContext;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.Constants;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class ResponseUnmarshaller {
    private Unmarshaller _unmarshal;
    private Stack<StackContext> _stack = new Stack();
    private boolean _isFetch;
    private XMLStreamReader _input;
    private VmodlField _field;
    private ResponseContext _responseContext;

    public ResponseUnmarshaller(VmodlField field, Unmarshaller unmarshal, boolean isFetch, XMLStreamReader input) {
        this._unmarshal = unmarshal;
        this._isFetch = isFetch;
        this._input = input;
        this._field = field;
    }

    public Object unmarshal() throws XMLStreamException, UnmarshallException {
        this._input.nextTag();
        if (!this._input.getName().equals(Constants.ENV_QNAME)) {
            throw new UnmarshallException();
        }
        EnvelopeStackContext context = new EnvelopeStackContext(this._field, this._unmarshal);
        this._stack.push(context);
        while (!this._stack.empty() && this._input.hasNext()) {
            switch (this._input.next()) {
                case 1: {
                    Map<QName, String> attrs = this.getAttrs();
                    StackContext parent = this._stack.peek();
                    StackContext current = parent.getNestedContext(this._input.getName(), attrs);
                    if (this._isFetch && current instanceof ReturnvalStackContext) {
                        ReturnvalStackContext returnValContext = (ReturnvalStackContext)current;
                        if (attrs.get(Constants.XSI_TYPE_QNAME) == null) {
                            returnValContext.setField(new FetchField(this._field));
                        } else {
                            returnValContext.setField(new FetchField(this._field, VmodlTypeMap.Factory.getTypeMap().getVmodlType(Object.class)));
                        }
                    }
                    if (current instanceof ReturnvalStackContext || current instanceof SoapFaultStackContext || current instanceof HeaderParamContext) {
                        current.setValue(this._input);
                        break;
                    }
                    this._stack.push(current);
                    break;
                }
                case 2: 
                case 8: {
                    this._stack.pop();
                }
            }
        }
        if (!this._stack.empty()) {
            throw new UnmarshallException();
        }
        if (null != context.getHeader()) {
            this._responseContext = (ResponseContext)((HeaderStackContext)context.getHeader()).getValue();
        }
        return context.getValue();
    }

    private Map<QName, String> getAttrs() {
        HashMap<QName, String> attrs = new HashMap<QName, String>(this._input.getAttributeCount());
        for (int index = 0; index < this._input.getAttributeCount(); ++index) {
            attrs.put(this._input.getAttributeName(index), this._input.getAttributeValue(index));
        }
        return attrs;
    }

    public ResponseContext getResponseContext() {
        return this._responseContext;
    }

    static class FetchField
    implements VmodlField {
        private VmodlField _field;
        private VmodlType _type;
        private static final String _returnVal = "returnval";

        public FetchField(VmodlField field, VmodlType type) {
            this._field = field;
            this._type = type;
        }

        public FetchField(VmodlField field) {
            this._field = field;
            this._type = this._field.getType();
        }

        public String getName() {
            return _returnVal;
        }

        public String getWsdlName() {
            return _returnVal;
        }

        public VmodlType getType() {
            return this._type;
        }

        public VmodlVersion getVersion() {
            return this._field.getVersion();
        }

        public String GetPrivilegeId() {
            return this._field.GetPrivilegeId();
        }

        public boolean isOptional() {
            return this._field.isOptional();
        }

        public VmodlType getManagedObjectType() {
            return this._field.getManagedObjectType();
        }

        public boolean isLink() {
            return this._field.isLink();
        }

        public boolean isLinkable() {
            return this._field.isLinkable();
        }

        public boolean isVisible(VmodlVersion version) {
            return this._field.isVisible(version);
        }

        public VmodlType getLinkType() {
            return this._field.getLinkType();
        }

        public boolean isSecret() {
            return this._field.isSecret();
        }

        public VmodlField.CollectionType getCollectionType() {
            return this._field.getCollectionType();
        }
    }
}

