/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.exception.InternalException;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import java.security.Principal;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.params.HttpParams;

public class CompiledHttpConfiguration {
    private static final Log LOG = LogFactory.getLog(CompiledHttpConfiguration.class);
    private boolean _active = true;
    private WeakHashMap<Client, Boolean> _usage = new WeakHashMap();
    private HttpConfiguration.CompressionSupport _compressionSupport;
    private ClientConnectionManager _connectionManager;
    private HttpParams _params;
    private long _keepAlivePeriod;
    private Principal _clientSSLToken;

    CompiledHttpConfiguration(ClientConnectionManager connectionManager, HttpParams params, HttpConfiguration.CompressionSupport compressionSupport, long keepAlivePeriod) {
        this._connectionManager = connectionManager;
        this._params = params;
        this._compressionSupport = compressionSupport;
        this._keepAlivePeriod = keepAlivePeriod;
    }

    HttpParams getParams() {
        return this._params;
    }

    ClientConnectionManager getConnectionManager() {
        return this._connectionManager;
    }

    HttpConfiguration.CompressionSupport getCompressionSupport() {
        return this._compressionSupport;
    }

    public synchronized boolean isActive() {
        return this._active;
    }

    synchronized void reserve(Client client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reserving CompiledHttpConfiguration@" + this.hashCode() + " to Client@" + client.hashCode()));
        }
        if (!this._active) {
            throw new IllegalStateException("HTTP configuration already shutdown!");
        }
        this._usage.put(client, Boolean.TRUE);
    }

    synchronized void release(Client client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing Client@" + client.hashCode() + " reference from CompiledHttpConfiguration@" + this.hashCode() + ", " + (this._usage.size() - 1) + " active clients left."));
        }
        this._usage.remove(client);
        if (this._usage.isEmpty() && this._active) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Shutting down CompiledHttpConfiguration@" + this.hashCode() + " as there are no more clients."));
            }
            this.shutdown();
        }
    }

    private void shutdown() {
        this._active = false;
        this._connectionManager.shutdown();
    }

    public long getKeepAlivePeriod() {
        return this._keepAlivePeriod;
    }

    public Principal getClientSSLToken() {
        return this._clientSSLToken;
    }

    public void setClientSSLToken(Principal clientSSLToken) {
        if (this._clientSSLToken != null) {
            if (this._clientSSLToken.getName() != clientSSLToken.getName()) {
                throw new InternalException("Trying to override already set SSL user token with different one.");
            }
            return;
        }
        this._clientSSLToken = clientSSLToken;
    }
}

