/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sslupdater.logbrowser;

import com.vmware.sslupdater.logbrowser.LogbrowserCertException;
import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceContent;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.ServiceInstance;
import com.vmware.vim.binding.lookup.version.version1;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.admin.client.AdminClient;
import com.vmware.vim.sso.admin.client.AdminClientFactory;
import com.vmware.vim.sso.admin.client.vmomi.VmomiClientConfiguration;
import com.vmware.vim.sso.admin.client.vmomi.VmomiClientFactory;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveTrustedCertsHelper {
    private static final Logger logger = LoggerFactory.getLogger(RetrieveTrustedCertsHelper.class);
    private static final URI SSO_ADMIN_TYPE = URI.create("urn:sso:admin");
    private static final String KEYSTORE_TYPE = "JKS";
    private static boolean isContextInitialized = false;
    private LookupService lookupService = null;

    public RetrieveTrustedCertsHelper() {
        if (!isContextInitialized) {
            VmodlContext.initContext((String[])new String[]{"com.vmware.vim.binding.lookup"});
            isContextInitialized = true;
        }
    }

    private void printCertificates(X509Certificate[] certificates, String outputCertFile) throws LogbrowserCertException {
        try {
            FileOutputStream outputStream = new FileOutputStream(outputCertFile);
            outputStream.write("-----BEGIN CERTIFICATE-----\r\n".getBytes("US-ASCII"));
            for (X509Certificate x509Certificate : certificates) {
                outputStream.write(Base64.encodeBase64((byte[])x509Certificate.getEncoded(), (boolean)true));
            }
            outputStream.write("-----END CERTIFICATE-----\r\n".getBytes("US-ASCII"));
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("Unable to write the certificates in the file {}", (Object)outputCertFile);
            throw new LogbrowserCertException("Unable to write the certificates in the file " + outputCertFile, e);
        }
        logger.info("Successfully wrote the trusted certificates to file: {}", (Object)outputCertFile);
    }

    private final AdminClient createSsoClient(URI ssoAdminLocation, KeyStore ssoKs) throws LogbrowserCertException {
        VmomiClientConfiguration config = new VmomiClientConfiguration.Builder(ssoAdminLocation).setSslConfiguration(new VmomiClientConfiguration.SslConfiguration(ThumbprintVerifier.Factory.createAllowAllThumbprintVerifier(), ssoKs, null)).createConfig();
        AdminClientFactory factory = VmomiClientFactory.createAdminClientFactory((VmomiClientConfiguration)config);
        AdminClient client = factory.createAdminClient();
        if (client == null) {
            logger.error("Unable to create Single Sign-On client {}", (Object)ssoAdminLocation.getAuthority());
            throw new LogbrowserCertException("Unable to create Single Sign-On client" + ssoAdminLocation.getAuthority());
        }
        return client;
    }

    private KeyStore createKeyStore(X509Certificate[] certificates) throws LogbrowserCertException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(null);
            for (X509Certificate cert : certificates) {
                keyStore.setCertificateEntry(cert.getSubjectDN().getName(), cert);
            }
            return keyStore;
        }
        catch (Exception e) {
            logger.error("Unable to create Single Sign-On certificate keystore", (Throwable)e);
            throw new LogbrowserCertException("Unable to create Single Sign-On certificate keystore", e);
        }
    }

    private X509Certificate createCertificateFromAnchor(String sslTrustAnchor) throws LogbrowserCertException {
        X509Certificate data = null;
        if (sslTrustAnchor != null) {
            try {
                CertificateFactory x509CertificateFactory = CertificateFactory.getInstance("X.509");
                data = (X509Certificate)x509CertificateFactory.generateCertificate(new ByteArrayInputStream(Base64.decodeBase64((byte[])sslTrustAnchor.getBytes("UTF8"))));
            }
            catch (Exception e) {
                logger.error("Invalid X.509 certificate. Data: {}", (Object)sslTrustAnchor, (Object)e);
                throw new LogbrowserCertException("Invalid X.509 certificate. Error: " + e.getMessage() + "; Data: " + sslTrustAnchor, e);
            }
        }
        return data;
    }

    private ServiceEndpoint findSingleServiceEndpoint(URI serviceType) throws LogbrowserCertException {
        Service service;
        SearchCriteria sc = new SearchCriteria();
        Service[] services = null;
        try {
            sc.serviceType = serviceType;
            sc.endpointProtocol = ServiceEndpoint.EndpointProtocol.vmomi.name();
            sc.viSite = this.lookupService.getViSite();
            services = this.lookupService.find(sc);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve service end point {}", (Object)serviceType.getAuthority());
            throw new LogbrowserCertException("Unable to retrieve service end point", e);
        }
        ServiceEndpoint serviceEndpoint = null;
        if (services != null && services.length > 0 && (service = services[0]).getEndpoints() != null && service.getEndpoints().length > 0) {
            serviceEndpoint = service.getEndpoints()[0];
        }
        if (serviceEndpoint == null) {
            logger.error("Unable to retrieve service end point {}", (Object)serviceType.getAuthority());
            throw new LogbrowserCertException("Unable to retrieve service end point");
        }
        logger.info("Service end point retrieved, url={}", (Object)serviceEndpoint.getUrl());
        return serviceEndpoint;
    }

    private X509Certificate[] getTrustedCertificates() throws LogbrowserCertException {
        ServiceEndpoint ssoAdminEndpoint = this.findSingleServiceEndpoint(SSO_ADMIN_TYPE);
        X509Certificate ssoCert = this.createCertificateFromAnchor(ssoAdminEndpoint.getSslTrustAnchor());
        X509Certificate[] certs = new X509Certificate[]{ssoCert};
        KeyStore ssoKeyStore = this.createKeyStore(certs);
        AdminClient client = this.createSsoClient(ssoAdminEndpoint.getUrl(), ssoKeyStore);
        Set certificatesSet = client.getServerConfigurator().getTrustedCertificates();
        X509Certificate[] trustedCertificates = certificatesSet.toArray(new X509Certificate[certificatesSet.size()]);
        logger.info("{} trusted certificate(s) were retrieved", (Object)trustedCertificates.length);
        return trustedCertificates;
    }

    private LookupService createLookupService(URI lookupServiceUri) throws LogbrowserCertException {
        LookupService ls = null;
        try {
            HttpConfiguration httpConfig = HttpConfiguration.Factory.newInstance();
            if (httpConfig != null) {
                httpConfig.setThumbprintVerifier(ThumbprintVerifier.Factory.createAllowAllThumbprintVerifier());
                Client lsClient = Client.Factory.createClient((URI)lookupServiceUri, version1.class, null, (HttpConfiguration)httpConfig);
                if (lsClient != null) {
                    ServiceContent lsSIC;
                    ManagedObjectReference managedObjectReference = new ManagedObjectReference();
                    managedObjectReference.setType("LookupServiceInstance");
                    managedObjectReference.setValue("ServiceInstance");
                    ServiceInstance lsSI = (ServiceInstance)lsClient.createStub(ServiceInstance.class, managedObjectReference);
                    if (lsSI != null && (lsSIC = lsSI.retrieveServiceContent()) != null) {
                        ls = (LookupService)lsClient.createStub(LookupService.class, lsSIC.getLookupService());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to contact Lookup Service at {}", (Object)lookupServiceUri.getAuthority());
            throw new LogbrowserCertException("Unable to contact Lookup Service", e);
        }
        if (ls == null) {
            throw new LogbrowserCertException("Unable to contact Lookup Service");
        }
        logger.info("Lookup Service contacted at {}", (Object)lookupServiceUri.getAuthority());
        this.lookupService = ls;
        return ls;
    }

    private static URI createURI(String uriString) throws LogbrowserCertException {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            logger.error("Invalid URI String, URL=" + uriString, (Throwable)e);
            throw new LogbrowserCertException("Invalid URI String, URL=" + uriString, e);
        }
    }

    public static void main(String[] args) {
        int i = 0;
        String lsUrl = "";
        String outputCertFile = "";
        while (i < args.length && args[i].startsWith("--")) {
            String arg;
            if ((arg = args[i++]).equals("--ls-url")) {
                if (i < args.length) {
                    lsUrl = args[i++];
                } else {
                    logger.error("--ls-url requires a Lookup Service URL");
                }
            }
            if (!arg.equals("--output-cert-file")) continue;
            if (i < args.length) {
                outputCertFile = args[i++];
                continue;
            }
            logger.error("--ouput_cert_file requires a absolute path filename");
        }
        if (i != args.length) {
            logger.error("Usage: [--ls-url aURL] [--output-cert-file aFile]");
            System.exit(1);
        } else {
            RetrieveTrustedCertsHelper helper = new RetrieveTrustedCertsHelper();
            try {
                URI lookupServiceUri = RetrieveTrustedCertsHelper.createURI(lsUrl);
                helper.createLookupService(lookupServiceUri);
                X509Certificate[] trustedCertificates = helper.getTrustedCertificates();
                helper.printCertificates(trustedCertificates, outputCertFile);
                logger.info("Successfully retrieved {} trusted certificate(s) from Single Sign-On-Admin and writing it to a file {}", (Object)trustedCertificates.length, (Object)outputCertFile);
            }
            catch (LogbrowserCertException e) {
                logger.error("Unable to retrieve trusted certificates from Single Sign-On-Admin", (Throwable)e);
                System.exit(1);
            }
            System.exit(0);
        }
    }
}

