/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl.marshaller;

import com.vmware.vim.binding.vmodl.Binary;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.exception.UnexpectedTypeException;
import com.vmware.vim.vmomi.core.soap.Marshaller;
import com.vmware.vim.vmomi.core.soap.impl.CalendarHelper;
import com.vmware.vim.vmomi.core.soap.impl.marshaller.FieldHelper;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlEnumType;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.impl.VmodlFieldImpl;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Calendar;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.binary.Base64;

public class MarshallerImpl
implements Marshaller {
    private static VmodlType LOCALIZED_METHOD_FAULT_TYPE = VmodlTypeMap.Factory.getTypeMap().getVmodlType("LocalizedMethodFault");
    private static final String MOREF_TYPE = "type";
    private static final String MOREF_GUID = "serverGuid";
    private static final String FAULT_ELEMENT = "fault";
    private static final String FAULT_MSG_ELEMENT = "localizedMessage";
    private static final String SOAP_FAULT_ELEMENT = "soapenv:Fault";
    private static final String SOAP_FAULT_CODE_ELEMENT = "faultcode";
    private static final String SOAP_FAULT_CODE = "ServerFaultCode";
    private static final String SOAP_FAULT_STRING_ELEMENT = "faultstring";
    private static final String SOAP_FAULT_DETAIL_ELEMENT = "detail";
    private static final String DEFAULT_ROOT_TAG = "obj";
    private static final String VERSION_ID_ATTRIBUTE = "versionId";
    private static final Charset US_ASCII_CHARSET = Charset.forName("US-ASCII");
    private final VmodlVersion _version;
    private final boolean _qsFormat;
    private final VmodlTypeMap _typeMap;
    private final VmodlType _arrayOfMoRefType;
    private final VmodlType _moRefType;

    public MarshallerImpl(VmodlVersion version, boolean qsFormat) {
        this._version = version;
        this._qsFormat = qsFormat;
        this._typeMap = VmodlTypeMap.Factory.getTypeMap();
        this._arrayOfMoRefType = this._typeMap.getVmodlType(ManagedObjectReference[].class);
        this._moRefType = this._typeMap.getVmodlType(ManagedObjectReference.class);
    }

    @Override
    public void marshal(VmodlField field, Object object, XMLStreamWriter output) throws MarshallException {
        if (object == null) {
            if (field != null && field.isOptional()) {
                return;
            }
            String message = field == null ? "Missing value for null (by default required) field" : "Missing value for required field " + field.getName();
            throw new MarshallException(message);
        }
        MarshalContext ctx = new MarshalContext(field, object, output, this._version.getNamespace());
        ctx.marshal();
    }

    @Override
    public void marshalSoapFault(Exception fault, String fieldWsdlName, XMLStreamWriter output) throws MarshallException {
        VmodlType faultType = this._typeMap.getVmodlType(fault.getClass());
        if (faultType == null || !(faultType instanceof ComplexType)) {
            throw new MarshallException(String.format("Unable to resolve type of fault class %1$s", fault.getClass()));
        }
        FieldHelper.DataObjectWrapperField field = new FieldHelper.DataObjectWrapperField(fieldWsdlName + "Fault", (ComplexType)faultType, this._version);
        MarshalContext ctx = new MarshalContext(field, fault, output, null);
        ctx.marshalSoapFault(field, fault);
    }

    class MarshalContext {
        private final VmodlField _field;
        private final Object _obj;
        private final XMLStreamWriter _writer;
        private String _defaultNamespace;

        public MarshalContext(VmodlField field, Object obj, XMLStreamWriter writer, String defaultNamespace) {
            this._field = field;
            this._obj = obj;
            this._writer = writer;
            this._defaultNamespace = defaultNamespace;
        }

        public void marshal() throws MarshallException {
            try {
                VmodlType dynamicType = this.getDynamicType(this._obj);
                if (this._field != null) {
                    this.marshalField(this._field, this._field.getName(), dynamicType, this._obj, dynamicType != this._field.getType(), this._field.getType());
                } else {
                    this.marshalField(null, MarshallerImpl.DEFAULT_ROOT_TAG, dynamicType, this._obj, true, null);
                }
                this._writer.flush();
            }
            catch (XMLStreamException e) {
                throw new MarshallException(e);
            }
        }

        public void marshalSoapFault(VmodlField field, Exception fault) throws MarshallException {
            try {
                this._writer.writeStartElement(MarshallerImpl.SOAP_FAULT_ELEMENT);
                this._writer.writeStartElement(MarshallerImpl.SOAP_FAULT_CODE_ELEMENT);
                this._writer.writeCharacters(MarshallerImpl.SOAP_FAULT_CODE);
                this._writer.writeEndElement();
                this._writer.writeStartElement(MarshallerImpl.SOAP_FAULT_STRING_ELEMENT);
                String message = fault.getMessage();
                if (message != null) {
                    this._writer.writeCharacters(message);
                }
                this._writer.writeEndElement();
                this._writer.writeStartElement(MarshallerImpl.SOAP_FAULT_DETAIL_ELEMENT);
                this.marshalField(field, field.getName(), field.getType(), fault, true, null);
                this._writer.writeEndElement();
                this._writer.writeEndElement();
                this._writer.flush();
            }
            catch (XMLStreamException e) {
                throw new MarshallException(e);
            }
        }

        public void marshalField(VmodlField field, String fieldName, VmodlType dynamicType, Object obj, boolean emitType, VmodlType staticType) throws XMLStreamException, MarshallException {
            switch (dynamicType.getKind()) {
                case BOOL: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case TYPE_NAME: 
                case METHOD_NAME: 
                case PROPERTY_PATH: {
                    String typeName = emitType ? dynamicType.getWsdlName() : null;
                    this.marshalString(field, fieldName, obj.toString(), typeName);
                    break;
                }
                case STRING: {
                    if (MarshallerImpl.this._qsFormat && field != null && field.isLink()) {
                        String key = obj.toString();
                        VmodlType linkableType = field.getLinkType();
                        this.marshalURIInQSFormat(fieldName, "#" + this.constructQsLinkId(key, linkableType), emitType);
                        break;
                    }
                    String typeName = emitType ? dynamicType.getWsdlName() : null;
                    this.marshalString(field, fieldName, obj.toString(), typeName);
                    break;
                }
                case URI: {
                    if (MarshallerImpl.this._qsFormat) {
                        this.marshalURIInQSFormat(fieldName, obj.toString(), emitType);
                        break;
                    }
                    String typeName = emitType ? dynamicType.getWsdlName() : null;
                    this.marshalString(field, fieldName, obj.toString(), typeName);
                    break;
                }
                case BINARY: {
                    String typeName = emitType ? dynamicType.getWsdlName() : null;
                    byte[] data2 = ((Binary)obj).asArray();
                    this.marshalString(field, fieldName, new String(Base64.encodeBase64((byte[])data2, (boolean)false), US_ASCII_CHARSET), typeName);
                    break;
                }
                case DATETIME: {
                    String typeName = emitType ? dynamicType.getWsdlName() : null;
                    String date = CalendarHelper.formatXsdDateTime((Calendar)obj);
                    this.marshalString(field, fieldName, date, typeName);
                    break;
                }
                case ENUM: {
                    String typeName = emitType ? dynamicType.getWsdlName() : null;
                    String enumLabel = ((VmodlEnumType)dynamicType).getEnumLabel((Enum)obj);
                    this.marshalString(field, fieldName, enumLabel, typeName);
                    break;
                }
                case ARRAY: {
                    this.marshalArray(field, fieldName, (VmodlArrayType)dynamicType, obj, emitType, staticType);
                    break;
                }
                case DATA_OBJECT: {
                    if (MarshallerImpl.this._qsFormat && field != null && field.isLinkable()) {
                        this.marshalComplexFieldWithId(field, fieldName, (ComplexType)dynamicType, obj, emitType, staticType);
                        break;
                    }
                    this.marshalComplexField(field, fieldName, (ComplexType)dynamicType, obj, emitType);
                    break;
                }
                case FAULT: {
                    this.marshalFault(field, fieldName, (ComplexType)dynamicType, obj, emitType);
                    break;
                }
                case MOREF: {
                    if (MarshallerImpl.this._qsFormat) {
                        this.marshalMoRefInQSFormat(fieldName, obj, emitType);
                        break;
                    }
                    this.marshalMoRef(field, fieldName, dynamicType, obj, emitType);
                    break;
                }
                case MANAGED_OBJECT: {
                    ManagedObject mo = (ManagedObject)obj;
                    this.marshalMoRef(field, fieldName, MarshallerImpl.this._moRefType, mo._getRef(), emitType);
                    break;
                }
                case ANY: {
                    throw new MarshallException(obj.toString() + " invalid instance");
                }
            }
        }

        private VmodlType getDynamicType(Object obj) {
            VmodlType dynamicType = MarshallerImpl.this._typeMap.getDynamicVmodlType(obj);
            if (dynamicType == null) {
                throw new UnexpectedTypeException(String.format("Unable to determine dynamic type of '%1$s'", obj.getClass()));
            }
            return dynamicType;
        }

        private void marshalFault(VmodlField field, String fieldName, ComplexType faultType, Object obj, boolean emitType) throws XMLStreamException, MarshallException {
            String typeName = emitType ? "LocalizedMethodFault" : null;
            VmodlType type = emitType ? LOCALIZED_METHOD_FAULT_TYPE : faultType;
            this.emitStartTag(field, fieldName, typeName, type);
            VmodlField versionedField = this.buildFieldForVersion(LOCALIZED_METHOD_FAULT_TYPE.getVersion());
            this.marshalComplexField(versionedField, MarshallerImpl.FAULT_ELEMENT, faultType, obj, true);
            this.marshalString(versionedField, MarshallerImpl.FAULT_MSG_ELEMENT, ((Exception)obj).getMessage(), null);
            this.emitEndTag();
        }

        private void marshalURIInQSFormat(String tag, String uri, boolean emitType) throws MarshallException, XMLStreamException {
            this.emitStartTag(tag, null, null);
            if (emitType) {
                this._writer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", MarshallerImpl.MOREF_TYPE, "qs:Link");
            }
            this._writer.writeAttribute("xlink", "http://www.w3.org/1999/xlink", "href", uri);
            this.emitEndTag();
        }

        private void marshalMoRefInQSFormat(String fieldName, Object obj, boolean emitType) throws XMLStreamException {
            ManagedObjectReference moref = (ManagedObjectReference)obj;
            this.emitStartTag(fieldName, null, null);
            if (emitType) {
                this._writer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", MarshallerImpl.MOREF_TYPE, "qs:ManagedObjectLink");
            }
            String uri = String.format("urn:vmomi:%s:%s:%s", moref.getType(), moref.getValue(), moref.getServerGuid());
            this._writer.writeAttribute("xlink", "http://www.w3.org/1999/xlink", "href", uri);
            this.emitEndTag();
        }

        private void marshalMoRef(VmodlField field, String fieldName, VmodlType type, Object obj, boolean emitType) throws XMLStreamException {
            ManagedObjectReference moref = (ManagedObjectReference)obj;
            this.emitStartTag(field, fieldName, emitType ? type.getWsdlName() : null, type);
            this._writer.writeAttribute(MarshallerImpl.MOREF_TYPE, moref.getType());
            if (moref.getServerGuid() != null && MarshallerImpl.this._version.isInternal()) {
                this._writer.writeAttribute(MarshallerImpl.MOREF_GUID, moref.getServerGuid());
            }
            this._writer.writeCharacters(moref.getValue());
            this.emitEndTag();
        }

        private void marshalArray(VmodlField field, String fieldName, VmodlArrayType dynamicType, Object obj, boolean emitType, VmodlType staticType) throws MarshallException, XMLStreamException {
            VmodlType itemType = dynamicType.getComponentType();
            String elementTagName = fieldName;
            if (staticType != null && !staticType.getKind().equals((Object)VmodlType.Kind.ANY) && staticType != dynamicType) {
                throw new MarshallException(String.format("Dynamic (%1$s) and declared (%2$s) types do not match and declared type is not ANY (is %3$s)", new Object[]{dynamicType.getWsdlName(), staticType.getWsdlName(), staticType.getKind()}));
            }
            if (Array.getLength(obj) == 0 && (field == null || VmodlType.Kind.ARRAY == field.getType().getKind() && !field.isOptional())) {
                throw new MarshallException("Empty array detected for required array field " + fieldName);
            }
            if (emitType) {
                if (itemType.getKind() == VmodlType.Kind.MANAGED_OBJECT) {
                    elementTagName = MarshallerImpl.this._moRefType.getWsdlName();
                    this.emitStartTag(field, fieldName, MarshallerImpl.this._arrayOfMoRefType.getWsdlName(), dynamicType);
                } else {
                    elementTagName = itemType.getWsdlName();
                    this.emitStartTag(field, fieldName, dynamicType.getWsdlName(), dynamicType);
                    field = this.buildFieldForVersion(itemType.getVersion());
                }
            }
            if (obj instanceof byte[]) {
                for (byte o : (byte[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null);
                }
            } else if (obj instanceof short[]) {
                for (short o : (short[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null);
                }
            } else if (obj instanceof int[]) {
                for (int o : (int[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null);
                }
            } else if (obj instanceof long[]) {
                for (long o : (long[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null);
                }
            } else if (obj instanceof float[]) {
                for (float o : (float[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null);
                }
            } else if (obj instanceof double[]) {
                for (double o : (double[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null);
                }
            } else if (obj instanceof boolean[]) {
                for (boolean o : (boolean[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null);
                }
            } else {
                Object[] array = (Object[])obj;
                for (int i = 0; i < array.length; ++i) {
                    VmodlType dynamicItemType;
                    Object o = array[i];
                    if (o == null) {
                        throw new MarshallException("Invalid value for field \"" + fieldName + "\": array contains null at index " + i);
                    }
                    this.marshalField(field, elementTagName, dynamicItemType, o, (dynamicItemType = this.getDynamicType(o)) != itemType, staticType != null && !staticType.getKind().equals((Object)VmodlType.Kind.ANY) ? ((VmodlArrayType)staticType).getComponentType() : null);
                }
            }
            if (emitType) {
                this.emitEndTag();
            }
        }

        private VmodlField buildFieldForVersion(VmodlVersion version) {
            VmodlFieldImpl field = new VmodlFieldImpl();
            field.setVersion(version);
            return field;
        }

        private ComplexType getCompatibleType(ComplexType type) {
            while (type != null && !type.IsVisible(MarshallerImpl.this._version)) {
                type = type.getBaseType();
            }
            return type;
        }

        private void marshalComplexFieldWithId(VmodlField field, String fieldName, ComplexType dynamicType, Object obj, boolean emitType, VmodlType staticType) throws XMLStreamException, MarshallException {
            ComplexTypeField keyField = dynamicType.getProperty("key");
            if (keyField == null || keyField.getType().getKind() != VmodlType.Kind.STRING && keyField.getType().getKind() != VmodlType.Kind.INT) {
                this.marshalComplexField(field, fieldName, dynamicType, obj, emitType);
                return;
            }
            String key = keyField.get(obj).toString();
            if (key == null) {
                this.marshalComplexField(field, fieldName, dynamicType, obj, emitType);
                return;
            }
            ComplexType origType = dynamicType;
            if ((dynamicType = this.getCompatibleType(dynamicType)) == null) {
                throw new MarshallException(String.format("Unable to obtain compatible type for '%1$s'", origType));
            }
            String typeName = emitType ? dynamicType.getWsdlName() : null;
            this.emitStartTag(fieldName, typeName, dynamicType);
            this._writer.writeAttribute("qs", "urn:vmware:queryservice", "id", this.constructQsLinkId(key, staticType));
            this.marshalSubFields(dynamicType, obj);
            this.emitEndTag();
        }

        private void marshalComplexField(VmodlField field, String fieldName, ComplexType dynamicType, Object obj, boolean emitType) throws XMLStreamException, MarshallException {
            ComplexType origType = dynamicType;
            if ((dynamicType = this.getCompatibleType(dynamicType)) == null) {
                throw new MarshallException(String.format("Unable to obtain compatible type for '%1$s'", origType));
            }
            String typeName = emitType ? dynamicType.getWsdlName() : null;
            this.emitStartTag(field, fieldName, typeName, dynamicType);
            this.marshalSubFields(dynamicType, obj);
            this.emitEndTag();
        }

        private void marshalSubFields(ComplexType dynamicType, Object obj) throws XMLStreamException, MarshallException {
            for (ComplexTypeField field : dynamicType.getProperties()) {
                if (!field.isVisible(MarshallerImpl.this._version)) continue;
                Object value = field.get(obj);
                if (value == null) {
                    if (field.isOptional()) continue;
                    throw new MarshallException(String.format("%1$s required property %2$s not set", dynamicType.getWsdlName(), field.getName()));
                }
                VmodlType staticFieldType = field.getType();
                VmodlType dynamicTypeField = this.getDynamicType(value);
                this.marshalField(field, field.getName(), dynamicTypeField, value, staticFieldType != dynamicTypeField, staticFieldType);
            }
        }

        private void marshalString(VmodlField field, String tag, String value, String typeName) throws XMLStreamException {
            if (value == null) {
                return;
            }
            if (typeName != null) {
                typeName = "xsd:" + typeName;
            }
            this.emitStartTag(field, tag, typeName, null);
            this._writer.writeCharacters(value);
            this.emitEndTag();
        }

        private void emitStartTag(String tag, String typeName, VmodlType type) throws XMLStreamException {
            this.emitStartTag(null, tag, typeName, type);
        }

        private void emitStartTag(VmodlField field, String tag, String typeName, VmodlType type) throws XMLStreamException {
            boolean emitDefaultNamespace = false;
            String effectiveNamespacePrefix = "";
            String effectiveNamespace = null;
            String typeNamespace = "";
            if (MarshallerImpl.this._version.shouldMarshallNamespace()) {
                if (this._defaultNamespace == null) {
                    effectiveNamespace = this._defaultNamespace = this.resolveNamespace(field, type);
                    emitDefaultNamespace = true;
                } else {
                    String startTagNamespace = this.resolveNamespace(field, type);
                    effectiveNamespace = this.getNonDefaultNamespace(startTagNamespace);
                    effectiveNamespacePrefix = this.buildNamespacePrefixWithColon(effectiveNamespace);
                }
                if (typeName != null && type != null) {
                    typeNamespace = this.resolveNamespace(null, type);
                }
            }
            this._writer.writeStartElement(effectiveNamespacePrefix + tag);
            if (typeName != null) {
                this.emitXsiType(typeName, typeNamespace);
            }
            if (emitDefaultNamespace) {
                this._writer.writeAttribute("xmlns", "urn:" + this._defaultNamespace);
            }
            if (field instanceof FieldHelper.RootField) {
                if (!emitDefaultNamespace) {
                    this._writer.writeAttribute("xmlns", "urn:" + this._defaultNamespace);
                }
                if (field.getVersion() != null && field.getVersion().getVersionId() != null && !field.getVersion().getVersionId().isEmpty()) {
                    this._writer.writeAttribute(MarshallerImpl.VERSION_ID_ATTRIBUTE, field.getVersion().getVersionId());
                }
            }
            this.emitNamespaceDeclarations(effectiveNamespace, typeNamespace);
        }

        private void emitNamespaceDeclarations(String ... namespaces) throws XMLStreamException {
            if (namespaces == null) {
                return;
            }
            for (String namesp : namespaces) {
                if (namesp == null || "".equals(namesp)) continue;
                this._writer.writeNamespace(namesp, "urn:" + namesp);
            }
        }

        private void emitXsiType(String typeName, String typeNamespace) throws XMLStreamException {
            String typePrefix = typeNamespace;
            if (!"".equals(typePrefix)) {
                typePrefix = typePrefix + ":";
            }
            if (typeName != null) {
                this._writer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", MarshallerImpl.MOREF_TYPE, typePrefix + typeName);
            }
        }

        private void emitEndTag() throws XMLStreamException {
            this._writer.writeEndElement();
        }

        private String constructQsLinkId(String key, VmodlType staticType) throws MarshallException {
            String encodedKey;
            try {
                encodedKey = URLEncoder.encode(key, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new MarshallException(String.format("Unable to encode '%1$s'", key));
            }
            return String.format("%1$s:%2$s", staticType.getWsdlName(), encodedKey);
        }

        private String resolveNamespace(VmodlField field, VmodlType type) {
            String namespace;
            if (field != null) {
                namespace = field.getVersion().getService().getServiceNamespace();
            } else if (type != null) {
                namespace = type.getVersion().getService().getServiceNamespace();
            } else {
                return "";
            }
            if (MarshallerImpl.this._version.isInternal()) {
                namespace = "internal" + namespace;
            }
            return namespace;
        }

        private String getNonDefaultNamespace(String namespace) {
            return this._defaultNamespace.equals(namespace) ? "" : namespace;
        }

        private String buildNamespacePrefixWithColon(String namespace) {
            return "".equals(namespace) ? "" : namespace + ":";
        }
    }
}

