/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl.unmarshaller;

import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.ArrayStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.ComplexStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.EnumStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.Environment;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.FaultStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.ManagedObjectStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.MoRefStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.PrimitiveStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContext;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.impl.VmodlFieldImpl;
import com.vmware.vim.vmomi.core.types.impl.VmomiServiceImpl;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

class StackContextFactory {
    private static VmodlType MANAGED_OBJECT_NOT_FOUND_FAULT_TYPE = VmodlTypeMap.Factory.getTypeMap().getVmodlType("ManagedObjectNotFound", new VmomiServiceImpl(null, "vim25"));

    StackContextFactory() {
    }

    public static StackContext newContext(StackContext parent, VmodlField field, QName name2, Map<QName, String> attrs, NamespaceContext namespaces, Environment env) throws UnmarshallException {
        VmodlType type = null;
        if (field == null) {
            type = StackContext.getType(field, attrs, env.isResolveMoType(), env.isQSFormat(), namespaces);
            if (type == null) {
                throw new UnmarshallException();
            }
            VmodlFieldImpl fieldImpl = new VmodlFieldImpl();
            fieldImpl.setLink(false);
            fieldImpl.setLinkable(false);
            fieldImpl.setName(name2.getLocalPart());
            fieldImpl.setOptional(false);
            fieldImpl.setSecret(false);
            fieldImpl.setCollectionType(VmodlField.CollectionType.NONE);
            fieldImpl.setType(VmodlTypeMap.Factory.getTypeMap().getVmodlType(Object.class));
            fieldImpl.setVersion(type.getVersion());
            fieldImpl.setWsdlName(name2.getLocalPart());
            field = fieldImpl;
        }
        if (!name2.getLocalPart().equals(field.getName())) {
            throw new UnmarshallException();
        }
        if (field.getType().getKind() == VmodlType.Kind.ARRAY) {
            VmodlArrayType arrType = (VmodlArrayType)field.getType();
            return new ArrayStackContext(field, arrType, parent, env);
        }
        if (type == null) {
            type = StackContext.getType(field, attrs, env.isResolveMoType(), env.isQSFormat(), namespaces);
        }
        switch (type.getKind()) {
            case MANAGED_OBJECT: {
                if (parent != null && MANAGED_OBJECT_NOT_FOUND_FAULT_TYPE.getTypeClass().isInstance(parent.getValue())) {
                    return new MoRefStackContext(field, type, parent, attrs, env);
                }
                return new ManagedObjectStackContext(field, type, parent, attrs, env);
            }
            case MOREF: {
                return new MoRefStackContext(field, type, parent, attrs, env);
            }
            case ARRAY: {
                return new ArrayStackContext(field, type, parent, env);
            }
            case FAULT: {
                if (parent == null || !(parent instanceof FaultStackContext)) {
                    return new FaultStackContext(field, type, parent, env);
                }
            }
            case DATA_OBJECT: {
                return new ComplexStackContext(field, type, parent, env);
            }
            case ENUM: {
                return new EnumStackContext(field, type, parent);
            }
            case ANY: {
                throw new UnmarshallException();
            }
        }
        return new PrimitiveStackContext(field, type, parent, attrs, env);
    }
}

