/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmomiService;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VmodlTypeMapImpl
implements VmodlTypeMap {
    private Map<String, VmodlType> _wsdlTypeMap = new ConcurrentHashMap<String, VmodlType>();
    private Map<Class<?>, VmodlType> _classTypeMap = new ConcurrentHashMap();
    private Map<String, ManagedMethod> _wsdlOperationMap = new ConcurrentHashMap<String, ManagedMethod>();
    private Map<String, VmodlType> _wsdlNamespaceTypeMap = new ConcurrentHashMap<String, VmodlType>();
    private Map<String, ManagedMethod> _wsdlNamespaceOperationMap = new ConcurrentHashMap<String, ManagedMethod>();

    @Override
    public VmodlType getVmodlType(String wsdlType) {
        return this._wsdlTypeMap.get(wsdlType);
    }

    @Override
    public VmodlType getVmodlType(Class<?> clazz) {
        return this._classTypeMap.get(clazz);
    }

    @Override
    public VmodlType getDynamicVmodlType(Object obj) {
        Class<?> componentClass;
        VmodlType componentType;
        Class<?> clazz = obj.getClass();
        VmodlType dynamicType = this.findDynamicType(clazz);
        if (dynamicType == null && clazz.isArray() && (componentType = this.findDynamicType(componentClass = clazz.getComponentType())) != null) {
            clazz = Array.newInstance(componentType.getTypeClass(), 0).getClass();
            dynamicType = this.getVmodlType(clazz);
        }
        return dynamicType;
    }

    private VmodlType findDynamicType(Class<?> clazz) {
        VmodlType dynamicType = this.getVmodlType(clazz);
        if (dynamicType != null) {
            return dynamicType;
        }
        for (Class<?> currentClass = clazz; currentClass != null && !currentClass.equals(Object.class) && dynamicType == null; currentClass = currentClass.getSuperclass()) {
            dynamicType = this.getVmodlType(currentClass);
        }
        if (dynamicType != null) {
            return dynamicType;
        }
        Class<?> doInterface = this.getObjectInterface(clazz);
        if (doInterface != null) {
            dynamicType = this.getVmodlType(doInterface);
        }
        return dynamicType;
    }

    private Class<?> getObjectInterface(Class<?> clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (this._classTypeMap.containsKey(interfaces[i])) {
                return interfaces[i];
            }
            Class<?> ret = this.getObjectInterface(interfaces[i]);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public ManagedMethod getManagedMethod(String wsdlOperationName) {
        return this._wsdlOperationMap.get(wsdlOperationName);
    }

    @Override
    public void registerType(String wsdlName2, VmodlType type) {
        String key;
        if (!this._wsdlTypeMap.containsKey(wsdlName2)) {
            this._wsdlTypeMap.put(wsdlName2, type);
        }
        if (!this._wsdlNamespaceTypeMap.containsKey(key = this.createWSDLKey(wsdlName2, type.getVersion().getService()))) {
            this._wsdlNamespaceTypeMap.put(key, type);
        }
    }

    @Override
    public void registerType(Class<?> clazz, VmodlType type) {
        if (this._classTypeMap.containsKey(clazz)) {
            throw new IllegalArgumentException(clazz.getName());
        }
        this._classTypeMap.put(clazz, type);
        this.registerType(type.getWsdlName(), type);
    }

    @Override
    public void registerOperations(ManagedObjectType type) {
        ManagedMethod[] methods = type.getMethods(false);
        for (int i = 0; i < methods.length; ++i) {
            ManagedMethod method = methods[i];
            this._wsdlOperationMap.put(method.getWsdlName(), method);
            this._wsdlNamespaceOperationMap.put(this.createWSDLKey(method.getWsdlName(), type.getVersion().getService()), method);
        }
    }

    @Override
    public void registerType(VmodlType type) {
        this.registerType(type.getTypeClass(), type);
    }

    @Override
    public ManagedMethod getManagedMethod(String wsdlOperationName, VmomiService service2) {
        return this._wsdlNamespaceOperationMap.get(this.createWSDLKey(wsdlOperationName, service2));
    }

    @Override
    public VmodlType getVmodlType(String wsdlType, VmomiService service2) {
        return this._wsdlNamespaceTypeMap.get(this.createWSDLKey(wsdlType, service2));
    }

    private String createWSDLKey(String wsdlName2, VmomiService service2) {
        if (service2 != null) {
            return service2.getServiceNamespace() + ":" + wsdlName2;
        }
        return wsdlName2;
    }
}

