@echo off

rem ##############################################################################
rem #
rem # Copyright (c) 2013 VMware, Inc. All rights reserved.
rem # -- VMware Confidential
rem #
rem ##############################################################################
call "%~dp0common" vSphere Web Client Update SSL certificate

if "%PROGRAMDATA%" == "" (
   set "DATA_DIR=%ALLUSERSPROFILE%\Application Data"
) else (
   set "DATA_DIR=%PROGRAMDATA%"
)

set "NGC_SSL_DIR=%DATA_DIR%\VMware\vSphere Web Client\ssl"
set "NGC_CRT_PATH=%NGC_SSL_DIR%\rui.crt"
set "NGC_KEY_PATH=%NGC_SSL_DIR%\rui.key"
set "NGC_PFX_PATH=%NGC_SSL_DIR%\rui.pfx"
set "NGC_KEYSTORE_PWD=testpassword"

rem set backup paths
set "NGC_ROLLBACK_DIR=%ROLLBACK_BACKUP_FOLDER%\ngc"
if NOT EXIST "%NGC_ROLLBACK_DIR%" (
   mkdir "%NGC_ROLLBACK_DIR%"
)
set "NGC_CRT_BACK=%NGC_ROLLBACK_DIR%\rui.crt"
set "NGC_KEY_BACK=%NGC_ROLLBACK_DIR%\rui.key"
set "NGC_PFX_BACK=%NGC_ROLLBACK_DIR%\rui.pfx"

set "OPEN_SSL_BIN=%~dp0openssl\openssl.exe"
set "NGC_UPDATE_TRUST_BAT=%~dp0ngc-update-trust.bat"

set ROLLBACK_EXIT_CODE=0

set "INPUT_CERT=%ngc_cert_chain%"
set "INPUT_KEY=%ngc_private_key%"

rem Strip spaces from JAVA_HOME
set JAVA_HOME=%JAVA_HOME:"=%
rem Check JAVA_HOME
if "%JAVA_HOME%"=="" (
   set last_error=JAVA_HOME variable is not set
   set EXIT_CODE=3
   goto :endFailure
)

if "%1" == "-rollback" (
   set EXIT_ROLLBACK_CODE=0
   goto :undoCertificateChanges
)

rem Check if NGC is installed
sc query vspherewebclientsvc > NUL
if ERRORLEVEL 1060 (
   set last_error=vSphere Web Client is not installed!
   set EXIT_CODE=2
   goto :endFailure
)

rem backup certs
rem use copy so permissions are properly inherited
copy /Y "%NGC_CRT_PATH%" "%NGC_CRT_BACK%"
copy /Y "%NGC_KEY_PATH%" "%NGC_KEY_BACK%"
copy /Y "%NGC_PFX_PATH%" "%NGC_PFX_BACK%"
del /F "%NGC_PFX_PATH%"

rem copy new certs
copy /Y "%INPUT_CERT%" "%NGC_CRT_PATH%"
copy /Y "%INPUT_KEY%" "%NGC_KEY_PATH%"

rem create keystore using openssl
call "%OPEN_SSL_BIN%" pkcs12 -export -in "%NGC_CRT_PATH%" -inkey "%NGC_KEY_PATH%" -out "%NGC_PFX_PATH%" -name rui -passout pass:%NGC_KEYSTORE_PWD% > nul 2> nul
if ERRORLEVEL 1 (
   set last_error=openssl.exe Cannot generate the keystore for the vSphere Web Client - errorlevel is %ERRORLEVEL%
   goto :undoCertificateChangesFailure
)

if NOT EXIST "%NGC_PFX_PATH%" (
   set last_error=Cannot find a generated keystore for the vSphere Web Client at: "%NGC_PFX_PATH%"
   goto :undoCertificateChangesFailure
)

call "%NGC_UPDATE_TRUST_BAT%"
if NOT "%ERRORLEVEL%"=="0" (
   rem last_error and exit_code should already be set
   goto :endFailure
)

:endSuccess
call "%~dp0common" Successfully updated the vSphere Web Client SSL certificate
exit /B 0

:undoCertificateChangesFailure
call "%~dp0common" "%last_error%"
set EXIT_ROLLBACK_CODE=1

:undoCertificateChanges
call "%~dp0common" Rolling back the certificate changes
if exist "%NGC_CRT_BACK%" (
   copy /Y "%NGC_CRT_BACK%" "%NGC_CRT_PATH%"
) else (
   call "%~dp0common" No backup exists for: "%NGC_CRT_BACK%"
)
if exist "%NGC_KEY_BACK%" (
   copy /Y "%NGC_KEY_BACK%" "%NGC_KEY_PATH%"
) else (
   call "%~dp0common" No backup exists for: "%NGC_KEY_BACK%"
)
if exist "%NGC_PFX_BACK%" (
   copy /Y "%NGC_PFX_BACK%" "%NGC_PFX_PATH%"
) else (
   call "%~dp0common" No backup exists for: "%NGC_PFX_BACK%"
)

call "%NGC_UPDATE_TRUST_BAT%"
if NOT "%ERRORLEVEL%"=="0" (
   rem last_error and exit_code should already be set
   goto :endFailure
)

call "%~dp0common" The vSphere Web Client is now using the previous certificate
exit /B %EXIT_ROLLBACK_CODE%

:endFailure
call "%~dp0common" "%last_error%"
exit /B %EXIT_CODE%
