@echo off

rem ##############################################################################
rem #
rem # Copyright (c) 2013 VMware, Inc. All rights reserved.
rem # -- VMware Confidential
rem #
rem ##############################################################################

set SERVICE_TRUST_TO_UPDATE=%~1
rem set NGC_INSTALL_DIR by reading registry
set NGC_REG_KEY="HKEY_LOCAL_MACHINE\SOFTWARE\VMware, Inc.\VMware Infrastructure\vSphere Web Client"
set NGC_INSTALL_DIR=
for /f "tokens=1,2*" %%a in ('reg query %NGC_REG_KEY% /v "InstallPath"') do (
   if "%%a"=="InstallPath" (
      set "NGC_INSTALL_DIR=%%c"
   )
)

if "%NGC_INSTALL_DIR%"=="" (
   set last_error=Cannot find vSphere Web Client installation directory in the registry
   set EXIT_CODE=3
   goto :endFailure
)

call "%~dp0common" vSphere installation directory is set to "%NGC_INSTALL_DIR%"

set "DOT_STARTED=%NGC_INSTALL_DIR%\.started"

rem In case of caching issues, restart NGC
call "%~dp0common" Restarting the vSphere Web Client service
echo Stopping vSphere Web Client... 1>&2
net stop vspherewebclientsvc 2>&1
echo vSphere Web Client stopped. 1>&2

rem delete .started file
call "%~dp0common" Removing .started file
if EXIST "%DOT_STARTED%" (
   del /F "%DOT_STARTED%"
)

rem Start NGC and wait for deployment to finish
call "%~dp0ngcutils\start-and-wait.bat"
if ERRORLEVEL 1 (
   goto :endFailure
)

call "%~dp0common" vSphere Web Client started

call "%~dp0common" Successfully updated the vSphere Web Client trust to %SERVICE_TRUST_TO_UPDATE%
exit /B 0

:endFailure
call "%~dp0common" "%last_error%"
exit /B "%EXIT_CODE%"
