#!/bin/bash

#####################################################
# Script for the task "CustomizeGuestOS"            #
# Will partition, format and mount additional disks #
# LVM mode                                          #
# Date: 06/17/2010                                  #
# Author: Anton S 				    #
#####################################################

source ../scripts/default/Common_Functions.sh || exit 3

#set -x

FILE_HDR="[VRMAgent:$0]"

fnSetupDisk()
{
	#WRK_DISK=/dev/sdb
	WRK_DISK=$1 
	#MNT_POINT=/mnt/disk1
	MNT_POINT=$2
	#FS_TYPE=ext3
	FS_TYPE=$3

        DSK_LABEL=$4
        DSK_SIZE=$5
	
	WRK_PART=${WRK_DISK}1

	fdisk -l | grep $WRK_PART
	if [ $? -eq 0 ]; then
			logger "$FILE_HDR Requested partition $WRK_PART already exist. Skip ..."
			#exit 1
			return 1
	fi

	mount | grep $MNT_POINT
	if [ $? -eq 0 ]; then
			logger "$FILE_HDR $MNT_POINT is already mounted. Skip ..."
			#exit 2
			return 2
	fi

	grep $MNT_POINT /etc/fstab
	if [ $? -eq 0 ]; then
			logger "$FILE_HDR $MNT_POINT exxist in /etc/fstab. Skip ..."
			#exit 3
			return 3
	fi

	which mkfs.$FS_TYPE
	if [ $? -ne 0 ]; then
			logger "$FILE_HDR Unknown FS type: $FS_TYPE. Skip ..."
			#exit 4
			return 4
	fi


#	echo "Creating $WRK_PART as $MNT_POINT with $FS_TYPE FS ..."

fdisk $WRK_DISK << EOF
n
p
1


t
8e
w
EOF

	rv=$?
	if [ $rv -ne 0 ]; then
		logger "$FILE_HDR fdisk failed, retuns $rv"
                return -1
        fi


	MNT_NAME=/dev/$VG_NAME/$DSK_LABEL

        partprobe $WRK_DISK
        rv=$?
        if [ $rv -ne 0 ]; then
                logger "$FILE_HDR partprobe failed, retuns $rv"
                return -1
        fi

        sleep 5

	pvcreate $WRK_PART
        rv=$?
        if [ $rv -ne 0 ]; then
                logger "$FILE_HDR pvcreate failed, retuns $rv"
                return -1
        fi

        vgextend $VG_NAME $WRK_PART
        rv=$?
        if [ $rv -ne 0 ]; then
                logger "$FILE_HDR vgextend failed, retuns $rv"
                return -1
        fi

        lvcreate -L ${DSK_SIZE}G -n $DSK_LABEL $VG_NAME        
        rv=$?
        if [ $rv -ne 0 ]; then
                logger "$FILE_HDR lvcreate failed, retuns $rv"
                return -1
        fi

	mkfs.$FS_TYPE -j $MNT_NAME

	if [ $? -ne 0 ]; then
		logger "$FILE_HDR mkfs.$FS_TYPE command failed. Stop ..."
		return -1
	fi

	mkdir -p $MNT_POINT

	mount $MNT_NAME $MNT_POINT

	if [ $? -ne 0 ]; then
		logger "$FILE_HDR Warning: cannot mount $WRK_PART as $MNT_POINT ..."
	fi

	echo "$MNT_NAME         $MNT_POINT              $FS_TYPE        defaults        1 2" >> /etc/fstab
	
	logger "$FILE_HDR Done creating $WRK_PART as $MNT_POINT with $FS_TYPE FS ..."
}


VG_NAME_FULL=`vgdisplay -c`
VG_NAME=`echo $VG_NAME_FULL | awk -F: '{print $1}'`

if [ -z $VG_NAME ]; then
    logger "$FILE_HDR Cannot get VG name. Stop ..."
    exit 1
fi

i=1
for disk in `ls -1 /dev/sd[b-z]`
do
	PropertyValue=$(python getprop.py VirtualMachine.Disk$i.Letter)
	mpt=$PropertyValue
	
	if [ "$mpt" != "False" ]; then
		PropertyValue=$(python getprop.py VirtualMachine.Disk$i.Filesystem)
		fs=$PropertyValue
		
		if [ "$fs" = "False" ]; then
			fs="ext3"
		fi

                PropertyValue=$(python getprop.py VirtualMachine.Disk$i.Label)
                label=$PropertyValue

                if [ "$label" = "False" ]; then
                        label="vrmvol$i"
                fi

                PropertyValue=$(python getprop.py VirtualMachine.Disk$i.Size)
                dsize=$PropertyValue

                if [ "$dsize" = "False" ]; then
                        dsize="0"
                fi
		
		logger "$FILE_HDR Trying to create LVM $disk as $mpt with $fs FS, label $label and size $dsize ..."
		
		fnSetupDisk $disk $mpt $fs $label $dsize
	fi
	
	(( i += 1 ))	
done

exit 0
