#!/usr/bin/python
import glob, sys
from bag import Bag

gateway_filename = '/etc/sysconfig/network'
if len(sys.argv) > 1:
    gateway_filename = sys.argv[1]

bag = Bag('properties.xml')

default_network_offset = 0
if bag.has_key('VirtualMachine.Network.Default'):
    default_network_offset = int(bag['VirtualMachine.Network.Default'])

gateway_key = 'VirtualMachine.Network%d.Gateway' % default_network_offset
if bag.has_key(gateway_key):
    lines = [ line.strip() for line in open(gateway_filename).readlines() if not line.startswith('GATEWAY=') ]
    lines.append('GATEWAY=%s' % bag[gateway_key])

    open(gateway_filename, 'w').write("\n".join(lines) + "\n")

for route_eth in glob.glob('/etc/sysconfig/network-scripts/route-eth*'):
    os.unlink(route_eth)

# vim: sw=4 ts=4 et
