SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER OFF;
GO
IF SCHEMA_ID(N'DynamicOps.VCloudModel') IS NULL EXECUTE(N'CREATE SCHEMA [DynamicOps.VCloudModel]');
GO

-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------
-- Creating table 'VcloudServers'
CREATE TABLE [DynamicOps.VCloudModel].[VcloudServers] (
    [Id] int IDENTITY(1,1) NOT NULL,
	[EndpointId] uniqueidentifier
);
GO

-- Creating table 'Organizations'
CREATE TABLE [DynamicOps.VCloudModel].[Organizations] (
    [Id] int IDENTITY(1,1) NOT NULL,
	[Href] nvarchar(128) NOT NULL,
	[UniqueId] nvarchar(128) NOT NULL,
	[Name] nvarchar(128) NOT NULL,
    [VcloudServerId] int NOT NULL
);
GO

-- Creating table 'VAppTemplates'
CREATE TABLE [DynamicOps.VCloudModel].[VAppTemplates] (
    [Id] int IDENTITY(1,1) NOT NULL,
	[Href] nvarchar(128) NOT NULL,
	[UniqueId] nvarchar(128) NOT NULL,
	[Name] nvarchar(128) NOT NULL,
	[Description] nvarchar(256) NULL,
	[TotalDiskSizeInGB] bigint NOT NULL,
	[TotalCpuCount] int NOT NULL,
	[TotalMemoryInMB] bigint NOT NULL,
    [OrganizationId] int NOT NULL
);
GO

-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------
-- Creating primary key on [Id] in table 'VcloudServers'
ALTER TABLE [DynamicOps.VCloudModel].[VcloudServers]
ADD CONSTRAINT [PK_VcloudServers]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'Organizations'
ALTER TABLE [DynamicOps.VCloudModel].[Organizations]
ADD CONSTRAINT [PK_Organizations]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'VAppTemplates'
ALTER TABLE [DynamicOps.VCloudModel].[VAppTemplates]
ADD CONSTRAINT [PK_VAppTemplates]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------
-- Creating foreign key on [VcloudServerId] in table 'Organizations'
ALTER TABLE [DynamicOps.VCloudModel].[Organizations]
ADD CONSTRAINT [FK_Organizations_VcloudServers_VcloudServerId]
    FOREIGN KEY ([VcloudServerId])
    REFERENCES [DynamicOps.VCloudModel].[VcloudServers]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_Organizations_VcloudServers_VcloudServerId'
CREATE INDEX [IX_FK_Organizations_VcloudServers_VcloudServerId]
ON [DynamicOps.VCloudModel].[Organizations]
    ([VcloudServerId]);
GO

-- Creating foreign key on [OrganizationId] in table 'VAppTemplates'
ALTER TABLE [DynamicOps.VCloudModel].[VAppTemplates]
ADD CONSTRAINT [FK_VAppTemplates_Organizations_OrganizationId]
    FOREIGN KEY ([OrganizationId])
    REFERENCES [DynamicOps.VCloudModel].[Organizations]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_VAppTemplates_Organizations_OrganizationId'
CREATE INDEX [IX_FK_VAppTemplates_Organizations_OrganizationId]
ON [DynamicOps.VCloudModel].[VAppTemplates]
    ([OrganizationId]);
GO
