CREATE SCHEMA [DynamicOps.VMWare] AUTHORIZATION [dbo]
GO

CREATE TABLE [DynamicOps.VMWare].[ReconfigureRequestNetworks](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[RequestId] [int] NOT NULL,
	[Operation] [int] NOT NULL,
	[RequestedNetworkName] [nvarchar](512) NOT NULL,
	[OriginalNetworkName] [nvarchar](512) NOT NULL,
	[OriginalNetworkUniqueId] [nvarchar](512) NOT NULL,
	[StaticIPv4Address] [varchar](40) NULL,
	[MACAddress] [nvarchar](50) NULL,
 CONSTRAINT [PK_ReconfigureRequestNetworks] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [DynamicOps.VMWare].[ReconfigureRequests](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[StateOperationUniqueId] [uniqueidentifier] NULL,
	[InitialCPU] [int] NOT NULL,
	[RequestedCPU] [int] NOT NULL,
	[InitialMemoryMB] [int] NOT NULL,
	[RequestedMemoryMB] [int] NOT NULL,
 CONSTRAINT [PK_ReconfigureRequests] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [DynamicOps.VMWare].[ReconfigureRequestStorages](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[RequestId] [int] NOT NULL,
	[Operation] [int] NOT NULL,
	[DeviceID] [nvarchar](256) NULL,
    [ExternalDiskId] [nvarchar](256) NULL,
	[DiskName] [nvarchar](256) NULL,
	[DriveLetter] [nvarchar](256) NULL,
	[Label] [nvarchar](256) NULL,
	[RequestedDiskSize] [int] NOT NULL,
	[OriginalDiskSize] [int] NOT NULL,
	[StorageName] [nvarchar](256) NULL,
	[StorageAllocationPolicyName] [nvarchar](128) NULL,
 CONSTRAINT [PK_RequestStorages] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestNetworks]  WITH CHECK ADD  CONSTRAINT [FK_ReconfigureRequestNetworks_ReconfigureRequests_RequestId] FOREIGN KEY([RequestId])
REFERENCES  [DynamicOps.VMWare].[ReconfigureRequests] ([Id])
GO

ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestNetworks] CHECK CONSTRAINT [FK_ReconfigureRequestNetworks_ReconfigureRequests_RequestId]
GO

ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestStorages]  WITH CHECK ADD  CONSTRAINT [FK_ReconfigureRequestStorages_ReconfigureRequests_RequestId] FOREIGN KEY([RequestId])
REFERENCES [DynamicOps.VMWare].[ReconfigureRequests] ([Id])
GO

ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestStorages] CHECK CONSTRAINT [FK_ReconfigureRequestStorages_ReconfigureRequests_RequestId]
GO


