import socket, struct

class IpAddr:
    def __init__(self, address, netmask):
        self.address = self.to_long(address)
        self.netmask = self.to_long(netmask)

    def to_long(self, dotted):
        return struct.unpack('=L', socket.inet_aton(dotted))[0]

    def to_dotted_quad(self, long):
        return socket.inet_ntoa(struct.pack('I', long))

    def network(self):
        return self.to_dotted_quad(self.address & self.netmask)

    def broadcast(self):
        x = (self.address & self.netmask) | ~self.netmask
        return self.to_dotted_quad(0xffffffff & x)

