#!/usr/bin/env perl

# Load module and libraries
use strict;
use IO::File;
use POSIX qw(setsid);
#require "../usr/lib/Agent_Core_Functions.pl";

# Initialize variable
my $quit = 0;
my $timeout = 0;
my $lastTaskTest;
my $pidfile = $ARGV[0];
my $reboot = "False";

# signal handler
$SIG{TERM} = $SIG{INT} = sub { $quit++;  };

# Become a daemon
my $fh = open_pid_file($pidfile);
my $pid = become_daemon();
print $fh $pid;
close $fh;

open(LOGDAEMON,">>../log/service_log.txt");
print LOGDAEMON "Service started\n";
# Run as a daemon
while(!$quit)
{
	# Run the agent here
	#$lastTaskTest = Run_Agent("GetWorkItem");
	chdir "/usr/share/gugent";
	system("./rungugent.sh");

	if (!$quit)
	{
		# Disabale the service
		my $disableService='chkconfig --del vrm-agent';
		`$disableService`;
		unlink("/etc/init.d/vrm-agent");
		
		# Log service uninstall
		open(FILE,">>../log/service_installation.txt");
		print FILE "Service has been removed\n";
		close(FILE);
		$quit++;
	}
	
	# Wait for 45 secs to be sure the machine is booted
	sleep(45);

	# Set the reboot command
	$reboot='reboot';
}

# Log service stopped
print LOGDAEMON "Service stopped\n";
close(LOGDAEMON);

# Test if a reboot is required
if ($reboot ne "False")
{
	`$reboot`;
}

# function to become daemon
sub become_daemon{
	die "can't fork" unless defined (my $child = fork);
	#Parent dies
	exit 0 if $child; 
	#Become session leader
	setsid();
	open(STDIN, "</dev/null");
	open(STDOUT, ">/dev/null");
	open(STDERR, ">&STDOUT");
	# Forget file creation mask
	umask(0);
	return $$;
}

# function to open the pid file
sub open_pid_file{
	my $file = shift;
	if (-e $file)
	{
		my $fh = IO::File->new($file) || return;
		my $pid = <$fh>;
		die "Server already running with PID $pid" if kill 0 => $pid;
		warn "Removing PID file for defunct agent process $pid.\n";
		die "Can't unlink PID file $file" unless -w $file && unlink $file;
	}
	return IO::File->new($file,O_WRONLY|O_CREAT|O_EXCL,0644) or die "Can't create $file: $!\n";
}
	
END{ unlink $pidfile if $$ == $pid; print LOGDAEMON "Service stopped\n"; close(LOGDAEMON); }
