#!/bin/bash

#####################################################
# Script for the task "CustomizeGuestOS"            #
# Will partition, format and mount additional disks #
# Date: 06/17/2010                                  #
# Author: Anton S 					                #
#####################################################

#source ../scripts/default/Common_Functions.sh || exit 3

FILE_HDR="[VRMAgent:$0]"

#set -x

fnSetupDisk()
{
	#WRK_DISK=/dev/sdb
	WRK_DISK=$1 
	#MNT_POINT=/mnt/disk1
	MNT_POINT=$2
	#FS_TYPE=ext3
	FS_TYPE=$3
	
	WRK_PART=${WRK_DISK}1

	fdisk -l | grep $WRK_PART
	if [ $? -eq 0 ]; then
		logger "$FILE_HDR Requested partition $WRK_PART already exist. Skip ..."
		return 1
	fi

	mount | grep $MNT_POINT
	if [ $? -eq 0 ]; then
		logger "$FILE_HDR $MNT_POINT is already mounted. Skip ..."
		return 2
	fi

	grep $MNT_POINT /etc/fstab
	if [ $? -eq 0 ]; then
		logger "$FILE_HDR $MNT_POINT exxist in /etc/fstab. Skip ..."
		return 3
	fi

	which mkfs.$FS_TYPE
	if [ $? -ne 0 ]; then
		logger "$FILE_HDR Unknown FS type: $FS_TYPE. Skip ..."
		return 4
	fi


#	echo "Creating $WRK_PART as $MNT_POINT with $FS_TYPE FS ..."

fdisk $WRK_DISK << EOF
n
p
1


t
83
w
EOF

	mkfs.$FS_TYPE $WRK_PART

	if [ $? -ne 0 ]; then
		logger "$FILE_HDR mkfs.$FS_TYPE command failed. Stop ..."
		return -1
	fi

	mkdir -p $MNT_POINT

	mount $WRK_PART $MNT_POINT

	if [ $? -ne 0 ]; then
		logger "$FILE_HDR Warning: cannot mount $WRK_PART as $MNT_POINT ..."
	fi

	echo "$WRK_PART         $MNT_POINT              $FS_TYPE        defaults        1 2" >> /etc/fstab
	
	logger "$FILE_HDR Done creating $WRK_PART as $MNT_POINT with $FS_TYPE FS ..."
}


i=1
for disk in `ls -1 /dev/sd[b-z]`
do
	PropertyName=VirtualMachine.Disk$i.Letter
	echo $PropertyName
	PropertyValue=$(python getprop.py $PropertyName)
	mpt=$PropertyValue
	echo $PropertyValue
	
	if [ "$mpt" != "False" ]; then
		PropertyValue=$(python getprop.py VirtualMachine.Disk$i.Filesystem)
		echo $PropertyValue
		fs=$PropertyValue
		echo $fs	
		if [ "$fs" = "False" ]; then
			fs="ext3"
			echo "set fs"
		fi
		
		logger "$FILE_HDR Trying to create $disk as $mpt with $fs FS ..."
		
		fnSetupDisk $disk $mpt $fs
	fi
	
	(( i += 1 ))	
done

exit 0
