#!/bin/bash

############################################
# Script for the task "CustomizeGuestOS"   #
############################################

FILE_HDR="[VRMAgent:$0]"

logger "$FILE_HDR Running custom scripts from $CUSTOMIZE_USER_DIR"

# Check if needs to run external script
PropertyValue=$(python getprop.py Linux.ExternalScript.Name)

if [ "$PropertyValue" != "False" ];then
        # Create directory to get script
        mkdir ../scriptsexternal

        # Get the type of storage for script, nfs/local
        PropertyValue=$(python getprop.py Linux.ExternalScript.LocationType)
        if [ "$PropertyValue" = "nfs" ];then
                # Get the nfs share address and path
                PropertyValue=$(python getprop.py Linux.ExternalScript.Server)
                Address=$PropertyValue
                PropertyValue=$(python getprop.py Linux.ExternalScript.Path)
                Address=$Address:$PropertyValue

                # Mount and make the script as exec
                mount -o nolock -t nfs $Address ../scriptsexternal || exit 8
                chmod -R a+x ../scriptsexternal || exit 8

                # Run the script
                PropertyValue=$(python getprop.py Linux.ExternalScript.Name)
                ../scriptsexternal/$PropertyValue || exit 8

                # Umount nfs share
                umount ../scriptsexternal
        elif [ "$PropertyValue" = "local" ];then
                 # Get path for the script
                PropertyValue=$(python getprop.py Linux.ExternalScript.Path)
                Path=$PropertyValue
                PropertyValue=$(python getprop.py Linux.ExternalScript.Name)
                Path=$Path/$PropertyValue

                # Copy the script
                cp $Path ../scriptsexternal/$PropertyValue
                chmod u+x ../scriptsexternal/$PropertyValue
                ` ../scriptsexternal/$PropertyValue` || exit 8
                rm  ../scriptsexternal/$PropertyValue
        else
                exit 8
        fi
        # Delete temp folder
        rm -rf ../scriptsexternal
fi

exit 0;
