/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld.nonpersistent;

import com.vmware.sva.blc.AbstractBlcEvent;
import com.vmware.sva.blc.AbstractBusinessLogicComponent;
import com.vmware.sva.bld.BusinessLogicDomainBlcAPI;
import com.vmware.sva.bld.nonpersistent.AbstractNonPersistentBld;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.VersionedSerializable;
import com.vmware.sva.services.blcevents.AbstractBlcMessage;
import com.vmware.sva.services.blcevents.BlcEventAddressInfo;
import com.vmware.sva.services.blcevents.memberdomain.AbstractMemberDomainBlcMessage;
import com.vmware.sva.services.logger.LoggerRequest;
import com.vmware.sva.services.logger.LoggerService;
import java.util.UUID;
import java.util.logging.Level;

@VersionedSerializable(value=false)
public abstract class AbstractNonPersistentBusinessLogicComponent
extends AbstractBusinessLogicComponent {
    private static final long serialVersionUID = 1L;

    public AbstractNonPersistentBusinessLogicComponent(String name, UUID parentBlcId, BusinessLogicDomainBlcAPI domain) {
        super(name, parentBlcId, domain);
    }

    public AbstractNonPersistentBusinessLogicComponent(UUID id, String name, UUID parentBlcId) {
        super(id, name, parentBlcId);
    }

    public AbstractNonPersistentBusinessLogicComponent(UUID id, String name, UUID parentBlcId, BusinessLogicDomainBlcAPI domain) {
        super(id, name, parentBlcId, domain);
    }

    @Override
    protected void sendLoggerRequest(LoggerRequest loggerRequest) {
        this.syncServiceRequest(LoggerService.SERVICE_ID, loggerRequest);
    }

    @Override
    protected boolean validEvent(AbstractBlcEvent event) {
        AbstractMemberDomainBlcMessage blcMessage;
        UUID srcBld;
        if (event instanceof AbstractMemberDomainBlcMessage && !(srcBld = (blcMessage = (AbstractMemberDomainBlcMessage)event).getHeader().getSourceBld()).equals(SvaConstants.DefaultUUID) && !srcBld.equals(this.getBld().getId())) {
            UUID instantiationId = blcMessage.getBldInstantiationId();
            UUID srcBldId = blcMessage.getHeader().getSourceBld();
            if (instantiationId == null) {
                this.log(Level.INFO, "Discarding message sent from FT domain " + srcBldId + " while this domain was OFFLINE");
                return false;
            }
            if (!instantiationId.equals(((AbstractNonPersistentBld)this.getBld()).getInstantiationId())) {
                this.log(Level.INFO, "Discarding message sent from FT domain " + srcBldId + " before this domain was rebooted");
                return false;
            }
        }
        return true;
    }

    @Override
    protected void sendMessage(BlcEventAddressInfo header, AbstractBlcMessage msg) {
        AbstractNonPersistentBld domain = (AbstractNonPersistentBld)this.getBld();
        msg.setBldInstantiationId(domain.getInstantiationId());
        super.sendMessage(header, msg);
    }
}

