/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld.persistent;

import com.vmware.sva.blc.AbstractBlcEvent;
import com.vmware.sva.blc.AbstractBusinessLogicComponent;
import com.vmware.sva.bld.AbstractBldTransactionOperation;
import com.vmware.sva.bld.AbstractBusinessLogicDomain;
import com.vmware.sva.bld.BldTransaction;
import com.vmware.sva.bld.BldType;
import com.vmware.sva.bld.DeleteBlcOperation;
import com.vmware.sva.bld.DequeueBlcEventOperation;
import com.vmware.sva.bld.QueueBlcEventOperation;
import com.vmware.sva.bld.SaveBlcOperation;
import com.vmware.sva.bld.ServiceRequestOperation;
import com.vmware.sva.bld.StartBlcOperation;
import com.vmware.sva.bld.persistent.PersistentBldDatabase;
import com.vmware.sva.bld.persistent.PersistentMessageService;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.domainservice.AbstractServiceEvent;
import com.vmware.sva.domainservice.UndeliveredServiceEvent;
import com.vmware.sva.services.blcevents.AbstractBlcMessage;
import com.vmware.sva.services.blcevents.BlcUndeliveredEvent;
import com.vmware.sva.services.blcevents.controlevent.BlcChildTerminatedEvent;
import com.vmware.sva.services.blcevents.controlevent.BlcStartEvent;
import com.vmware.sva.services.logger.LoggerService;
import com.vmware.sva.services.messaging.BlcMessageRequest;
import com.vmware.sva.services.shareddatabase.SharedObjectService;
import com.vmware.sva.services.zkupgrade.ZkUpgradeService;
import com.vmware.sva.util.SystemUtils;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public abstract class AbstractPersistentBld
extends AbstractBusinessLogicDomain
implements Runnable {
    private static final long serialVersionUID = 1L;
    private final LoggerService loggerService;
    private final PersistentMessageService messageService;
    private SharedObjectService sharedObjectService = null;
    private PersistentBldDatabase database = null;

    public AbstractPersistentBld(UUID bldId, String name) throws Exception {
        super(bldId, name);
        this.database = new PersistentBldDatabase(bldId.toString());
        if (!this.database.validate()) {
            throw new Exception("Inconsistent database for domain " + this.getName());
        }
        this.loggerService = new LoggerService(this);
        this.messageService = new PersistentMessageService(this);
        this.setSharedObjectService(new SharedObjectService(this));
        new ZkUpgradeService(this);
    }

    @Override
    public void setDefaultBlc(AbstractBusinessLogicComponent blc) throws Exception {
        if (this.isInitialized()) {
            throw new Exception("BLD already started");
        }
        this.database.addBlc(blc);
        this.database.commit();
        this.blcMap.put(blc.getId(), blc);
        blc.queueEvent(new BlcStartEvent(blc.getId()));
    }

    @Override
    public BldType getType() {
        return BldType.Persistent;
    }

    public boolean isInitialized() throws Exception {
        return !this.database.getBlcList().isEmpty();
    }

    @Override
    public PersistentBldDatabase getDatabase() {
        return this.database;
    }

    @Override
    public boolean startDomain() {
        try {
            for (BldTransaction transaction : this.database.getTransactions()) {
                this.transactionQueue.add(transaction);
            }
            for (AbstractBusinessLogicComponent blc : this.database.getBlcList()) {
                UUID blcId = blc.getId();
                this.blcMap.put(blcId, blc);
                List<AbstractBlcEvent> events = this.database.getBlcEventQueue(blcId);
                this.log(Level.FINE, "Recovering " + events.size() + " events");
                blc.setEventQueue(events);
            }
            this.startReplica(null);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to start domain: " + e.getMessage(), e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean stopDomain() {
        return true;
    }

    @Override
    protected void closeDomain() {
        try {
            this.database.close();
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to close database: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitTransaction(BldTransaction transaction) {
        AbstractPersistentBld abstractPersistentBld = this;
        synchronized (abstractPersistentBld) {
            try {
                this.database.addTransaction(transaction);
                this.database.commit();
            }
            catch (Exception e) {
                assert (false) : "Could not persist BLD transaction: " + e.getMessage();
                this.log(Level.SEVERE, "Could not persist BLD transaction: " + e.getMessage());
            }
        }
        this.transactionQueue.add(transaction);
    }

    @Override
    public void queuePersistentBlcEvent(UUID blcId, AbstractBlcEvent event) {
        try {
            if (event.getPersistent()) {
                this.database.addBlcEvent(blcId, event);
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Failed to persist BLC event: " + e.getMessage());
        }
    }

    @Override
    public boolean isMaster() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processPersistTransaction(BldTransaction transaction) {
        AbstractPersistentBld abstractPersistentBld = this;
        synchronized (abstractPersistentBld) {
            for (AbstractBldTransactionOperation op : transaction) {
                if (op instanceof ServiceRequestOperation) {
                    this.handleServiceRequestOperation((ServiceRequestOperation)op);
                    continue;
                }
                if (op instanceof StartBlcOperation) {
                    this.handleStartBlcOperation((StartBlcOperation)op);
                    continue;
                }
                if (op instanceof DeleteBlcOperation) {
                    this.handleDeleteBlcOperation((DeleteBlcOperation)op);
                    continue;
                }
                if (op instanceof DequeueBlcEventOperation) {
                    this.handleDequeueBlcEventOperation((DequeueBlcEventOperation)op);
                    continue;
                }
                if (op instanceof SaveBlcOperation) {
                    this.handleSaveBlcOperation((SaveBlcOperation)op);
                    continue;
                }
                if (op instanceof QueueBlcEventOperation) {
                    this.handleQueueBlcEventOperation((QueueBlcEventOperation)op);
                    continue;
                }
                this.log(Level.SEVERE, "Unrecognized transaction operation: " + ((Object)((Object)op)).getClass());
            }
            try {
                this.database.removeTransaction();
            }
            catch (SQLException e) {
                this.log(Level.SEVERE, "Unable to remove BLD transaction: " + e.getMessage());
            }
            try {
                this.database.commit();
            }
            catch (SQLException e) {
                this.log(Level.SEVERE, "Unable to commit database update: " + e.getMessage());
            }
        }
    }

    @Override
    protected void deleteDatabase() throws Exception {
        if (this.database != null) {
            this.database.delete();
            this.database = null;
        }
    }

    private void handleServiceRequestOperation(ServiceRequestOperation op) {
        try {
            this.handlePersistentServiceRequest(op, false);
        }
        catch (Exception e) {
            String msg = "Could not persist service request: " + (Object)((Object)op);
            this.log(Level.SEVERE, msg, e);
            assert (false) : msg;
            SystemUtils.reboot(false, null, this);
        }
    }

    private void handleStartBlcOperation(StartBlcOperation op) {
        try {
            this.database.addBlc(op.getBlc());
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not persist created BLC: " + e.getMessage());
        }
    }

    private void handleDeleteBlcOperation(DeleteBlcOperation op) {
        try {
            UUID blcId = op.getBlcId();
            AbstractBusinessLogicComponent blc = (AbstractBusinessLogicComponent)this.blcMap.get(blcId);
            if (blc == null) {
                String errorMsg = "Attempt to delete non-existing BLC";
                assert (false) : errorMsg;
                this.log(Level.SEVERE, errorMsg);
            } else {
                UUID parentBlcId = blc.getParentBlcId();
                this.database.deleteBlc(op.getBlcId());
                if (parentBlcId != null) {
                    if (!this.blcMap.keySet().contains(parentBlcId)) {
                        String errorMsg = "Parent of deleted BLC does not exists";
                        assert (false) : errorMsg;
                        this.log(Level.SEVERE, errorMsg);
                    } else {
                        BlcChildTerminatedEvent event = new BlcChildTerminatedEvent(blcId);
                        this.database.addBlcEvent(parentBlcId, event);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not delete BLC: " + e.getMessage());
        }
    }

    private void handleDequeueBlcEventOperation(DequeueBlcEventOperation op) {
        try {
            this.database.removeBlcEvent(op.getBlcId(), op.getEventId());
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not dequeue BLC event");
        }
    }

    private void handleSaveBlcOperation(SaveBlcOperation op) {
        try {
            this.database.updateBlc(op.getBlc());
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not save BLC");
        }
    }

    private void handleQueueBlcEventOperation(QueueBlcEventOperation op) {
        try {
            UUID blcId;
            AbstractBlcEvent event = op.getEvent();
            if (event.getPersistent() && !this.database.addBlcEvent(blcId = op.getBlcId(), event)) {
                if (event instanceof AbstractBlcMessage) {
                    if (!(event instanceof BlcUndeliveredEvent)) {
                        this.log(Level.WARNING, "Message for non-existent BLC");
                        BlcUndeliveredEvent undeliveredBlcMessage = new BlcUndeliveredEvent(this.getId(), (AbstractBlcMessage)event);
                        BlcMessageRequest blcMessageRequest = new BlcMessageRequest(undeliveredBlcMessage);
                        try {
                            this.getService(SvaConstants.MESSAGE_SERVICE_ID).persistRequest(blcMessageRequest);
                        }
                        catch (Exception e) {
                            this.log(Level.SEVERE, "Could not return undelivered message", e);
                        }
                    }
                } else if (event instanceof AbstractServiceEvent) {
                    this.log(Level.WARNING, "Service event for non-existent BLC");
                    AbstractServiceEvent origServiceEvent = (AbstractServiceEvent)event;
                    UUID serviceId = origServiceEvent.getServiceId();
                    UndeliveredServiceEvent undeliveredServiceEvent = new UndeliveredServiceEvent(blcId, origServiceEvent);
                    try {
                        this.getService(serviceId).persistRequest(undeliveredServiceEvent);
                    }
                    catch (Exception e) {
                        this.log(Level.SEVERE, "Cold not return undelivered event", e);
                    }
                } else {
                    this.log(Level.SEVERE, "Event for non-existent BLC");
                }
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not persist BLC event");
        }
    }

    public LoggerService getLoggerService() {
        return this.loggerService;
    }

    public PersistentMessageService getMessageService() {
        return this.messageService;
    }

    public void setSharedObjectService(SharedObjectService sharedObjectService) {
        this.sharedObjectService = sharedObjectService;
    }

    public SharedObjectService getSharedObjectService() {
        return this.sharedObjectService;
    }

    @Override
    public UUID getBldInstantiationId(UUID bldId) {
        assert (false) : "this method cannot be called from a persistent domain";
        throw new UnsupportedOperationException("this method cannot be called from a persistent domain");
    }
}

