/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.database;

import com.vmware.sva.bld.BldException;
import com.vmware.sva.database.AbstractDbTable;
import com.vmware.sva.database.VersionDbTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public abstract class AbstractSeqNumDbTable
extends AbstractDbTable {
    private static final String DB_TABLE_COLUMNS = "(domain VARCHAR(255), seqnum BIGINT)";
    private final Map<String, Long> seqNumMap = new HashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSeqNumDbTable(Connection connection, String tableName) throws SQLException, BldException {
        super(connection, tableName, DB_TABLE_COLUMNS);
        Statement statement = connection.createStatement();
        try {
            ResultSet rs = statement.executeQuery("SELECT * FROM \"" + tableName + "\"");
            while (rs.next()) {
                this.seqNumMap.put(rs.getString("domain"), rs.getLong("seqnum"));
            }
        }
        finally {
            statement.close();
        }
    }

    public boolean hasSeqNum(UUID domainId) {
        return this.hasSeqNum(domainId.toString());
    }

    public long getSeqNum(UUID domainId) {
        String domainIdStr = domainId.toString();
        if (!this.hasSeqNum(domainIdStr)) {
            return 0L;
        }
        return this.seqNumMap.get(domainIdStr);
    }

    public void setSeqNum(UUID domainId, long seqNum) throws SQLException {
        this.setSeqNum(domainId.toString(), seqNum);
    }

    public long nextSeqNum(UUID domainId) throws SQLException {
        long seqNum = this.getSeqNum(domainId) + 1L;
        this.setSeqNum(domainId, seqNum);
        return seqNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSeqNum(UUID domainId) throws SQLException {
        String domainIdStr = domainId.toString();
        if (this.hasSeqNum(domainIdStr)) {
            PreparedStatement pstmt = this.connection.prepareStatement("DELETE FROM \"" + this.tableName + "\" WHERE domain = ?");
            try {
                pstmt.setString(1, domainIdStr);
                pstmt.execute();
            }
            finally {
                pstmt.close();
            }
        }
    }

    public Map<UUID, Long> getSeqNumMap() throws Exception {
        return AbstractSeqNumDbTable.getSeqNumMap(this.connection, this.tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<UUID, Long> getSeqNumMap(Connection connection, String tableName) throws Exception {
        Statement statement = connection.createStatement();
        try {
            ResultSet rs = statement.executeQuery("SELECT * FROM \"" + tableName + "\"");
            HashMap<UUID, Long> seqNumMap = new HashMap<UUID, Long>();
            while (rs.next()) {
                UUID domain = UUID.fromString(rs.getString("domain"));
                long seqNum = rs.getLong("seqnum");
                seqNumMap.put(domain, seqNum);
            }
            HashMap<UUID, Long> hashMap = seqNumMap;
            return hashMap;
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate() {
        this.log(Level.FINE, "Validating database table " + this.tableName);
        try {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet rs = statement.executeQuery("SELECT * FROM \"" + this.tableName + "\"");
                HashSet<UUID> domainMap = new HashSet<UUID>();
                while (rs.next()) {
                    UUID domain = UUID.fromString(rs.getString("domain"));
                    rs.getLong("seqnum");
                    if (domainMap.contains(domain)) {
                        throw new Exception("Duplicate domain ID " + domain + " found in " + this.tableName);
                    }
                    domainMap.add(domain);
                    this.log(Level.FINE, "Validated domain ID " + domain);
                }
            }
            finally {
                statement.close();
            }
            this.log(Level.FINE, "Database table " + this.tableName + " is valid");
            return true;
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to validate table " + this.tableName, e);
            return false;
        }
    }

    @Override
    public void upgrade(VersionDbTable versionTable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSeqNum(String domainId, long seqNum) throws SQLException {
        if (!this.hasSeqNum(domainId)) {
            PreparedStatement pstmt = this.connection.prepareStatement("INSERT INTO \"" + this.tableName + "\" VALUES(?,?)");
            try {
                pstmt.setString(1, domainId);
                pstmt.setLong(2, seqNum);
                pstmt.execute();
                this.seqNumMap.put(domainId, seqNum);
            }
            finally {
                pstmt.close();
            }
        }
        PreparedStatement pstmt = this.connection.prepareStatement("UPDATE \"" + this.tableName + "\" SET seqnum = ? WHERE domain = ?");
        try {
            pstmt.setLong(1, seqNum);
            pstmt.setString(2, domainId);
            pstmt.execute();
            this.seqNumMap.put(domainId, seqNum);
        }
        finally {
            pstmt.close();
        }
    }

    private boolean hasSeqNum(String domainIdStr) {
        return this.seqNumMap.containsKey(domainIdStr);
    }
}

