/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.database;

import com.vmware.sva.blc.AbstractBlcEvent;
import com.vmware.sva.bld.BldException;
import com.vmware.sva.database.AbstractPersistentBldDatabase;
import com.vmware.sva.database.AbstractQueueDbTable;
import com.vmware.sva.util.SystemUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public class BlcEventQueueDbTable
extends AbstractQueueDbTable {
    public BlcEventQueueDbTable(Connection connection, UUID blcId, AbstractPersistentBldDatabase database) throws SQLException, BldException {
        super(connection, "EVENT_QUEUE_" + blcId.toString(), database);
    }

    public void addEvent(AbstractBlcEvent event) throws Exception {
        this.addObject((Object)event);
    }

    public void removeEvent(UUID eventId) throws SQLException {
        try {
            if (eventId != null) {
                AbstractBlcEvent tail = (AbstractBlcEvent)((Object)this.getTail());
                if (tail == null) {
                    this.forceReboot("Attempt to remove event from empty queue " + this.tableName + " : expected ID=" + eventId);
                } else {
                    UUID tailId = tail.getEventId();
                    if (tailId != null && !tailId.equals(eventId)) {
                        this.forceReboot("Removing event with wrong ID from queue " + this.tableName + " : expected ID=" + eventId + " tail ID=" + tailId + " tail=" + (Object)((Object)tail));
                    }
                }
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to get tail, expecting event ID=" + eventId, e);
            SystemUtils.reboot(true, null, null);
        }
        this.removeObject();
    }

    public List<AbstractBlcEvent> getEvents() throws Exception {
        List<Object> objs = this.getObjects();
        ArrayList<AbstractBlcEvent> events = new ArrayList<AbstractBlcEvent>();
        for (Object obj : objs) {
            events.add((AbstractBlcEvent)((Object)obj));
        }
        return events;
    }
}

