/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.domainservice;

import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.exceptions.NotReadyForRequestsException;
import com.vmware.sva.domainservice.AbstractDomainService;
import com.vmware.sva.domainservice.AbstractManagementRequest;
import com.vmware.sva.domainservice.AbstractManagementResponse;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.domainservice.FlushServiceQueueRequest;
import com.vmware.sva.domainservice.FlushServiceQueueResponse;
import com.vmware.sva.domainservice.PendingManagementRequest;
import com.vmware.sva.domainservice.SendManagementEventRequest;
import com.vmware.sva.domainservice.UndeliveredManagementRequest;
import com.vmware.sva.domainservice.UndeliveredServiceEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public abstract class AbstractRemoteRequestService
extends AbstractDomainService {
    private static final long serialVersionUID = 1L;
    private final ConcurrentMap<UUID, PendingManagementRequest> pendingRequests = new ConcurrentHashMap<UUID, PendingManagementRequest>();
    private boolean receivingEnabled = false;

    public AbstractRemoteRequestService(UUID id, String name, BusinessLogicDomainServiceAPI domain) throws Exception {
        super(id, name, domain);
    }

    @Override
    public UUID getServiceId() {
        return this.getId();
    }

    @Override
    public void persistRequest(AbstractServiceRequest arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponse(AbstractManagementResponse response) {
        AbstractManagementRequest origRequest = response.getRequest();
        UUID requestId = origRequest.getRequestId();
        PendingManagementRequest pr = (PendingManagementRequest)this.pendingRequests.remove(requestId);
        if (pr == null) {
            Date requestTime = origRequest.getRequestTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            this.log(Level.SEVERE, "Response to unknown request (" + ((Object)((Object)origRequest)).getClass() + " ID=" + requestId + " @ " + dateFormat.format(requestTime) + "): assuming SVA has restarted since receiving request: " + ((Object)((Object)response)).getClass());
        } else {
            PendingManagementRequest pendingManagementRequest = pr;
            synchronized (pendingManagementRequest) {
                pr.setResponse(response);
                pr.notifyAll();
            }
        }
    }

    protected abstract void handleManagementEvent(SendManagementEventRequest var1);

    @Override
    public void postpersistRequest(AbstractServiceRequest request) {
        if (request instanceof UndeliveredServiceEvent) {
            UndeliveredServiceEvent undeliveredServiceEvent = (UndeliveredServiceEvent)request;
            if (undeliveredServiceEvent.getOrigEvent() instanceof AbstractManagementRequest) {
                AbstractManagementRequest origRequest = (AbstractManagementRequest)undeliveredServiceEvent.getOrigEvent();
                UUID blcId = request.getBlcId();
                UndeliveredManagementRequest response = new UndeliveredManagementRequest(blcId, origRequest);
                this.handleResponse(response);
            }
        } else if (request instanceof FlushServiceQueueRequest) {
            this.handleFlushServiceQueueRequest((FlushServiceQueueRequest)request);
        } else if (request instanceof AbstractManagementResponse) {
            this.handleResponse((AbstractManagementResponse)request);
        } else if (request instanceof SendManagementEventRequest) {
            this.handleManagementEvent((SendManagementEventRequest)request);
        } else {
            String msg = "Unexpected service request: " + (Object)((Object)request);
            Exception e = new Exception(msg);
            this.log(Level.SEVERE, "Invalid service request", e);
            assert (false) : msg;
        }
    }

    public void enableReceiving() {
        this.receivingEnabled = true;
    }

    public void disableReceiving() {
        this.receivingEnabled = false;
    }

    private void handleFlushServiceQueueRequest(FlushServiceQueueRequest request) {
        UUID blcId = request.getBlcId();
        UUID requestId = request.getRequestId();
        FlushServiceQueueResponse response = new FlushServiceQueueResponse(requestId, this.getServiceId());
        this.queueBlcEventFromServiceEvent(blcId, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractManagementResponse sendRequestToBlc(UUID blcId, AbstractManagementRequest request) throws Exception {
        PendingManagementRequest pr = new PendingManagementRequest();
        UUID requestId = request.getRequestId();
        Date now = new Date();
        Date timeout = request.getRequestTimeout() == 0L ? new Date(now.getTime() + SvaConstants.SVA_MGMT_CLIENT_SERVICE_TIMEOUT) : new Date(now.getTime() + request.getRequestTimeout());
        this.log(Level.INFO, "Received request (ID = " + request.getRequestId() + "): " + ((Object)((Object)request)).getClass());
        if (!this.receivingEnabled) {
            throw new NotReadyForRequestsException();
        }
        PendingManagementRequest oldValue = this.pendingRequests.putIfAbsent(requestId, pr);
        if (oldValue != null) {
            throw new Exception("Request already pending for request ID: " + requestId);
        }
        this.queueBlcEventFromServiceEvent(blcId, request);
        try {
            PendingManagementRequest pendingManagementRequest = pr;
            synchronized (pendingManagementRequest) {
                while (pr.getResponse() == null) {
                    if (!timeout.after(now)) {
                        throw new Exception("Timed out waiting for reply to request (ID = " + requestId + " ): " + ((Object)((Object)request)).getClass());
                    }
                    pr.wait(timeout.getTime() - now.getTime());
                    now = new Date();
                }
            }
        }
        catch (Exception e) {
            this.pendingRequests.remove(requestId);
            throw e;
        }
        finally {
            this.log(Level.INFO, "Finished processing request (ID = " + requestId + "): " + ((Object)((Object)request)).getClass());
        }
        return pr.getResponse();
    }

    protected AbstractManagementResponse sendRequestToBlc(AbstractManagementRequest request) throws Exception {
        return this.sendRequestToBlc(SvaConstants.DefaultUUID, request);
    }

    protected AbstractManagementResponse processRequest(UUID blcId, AbstractManagementRequest request) throws Exception {
        AbstractManagementResponse response = null;
        try {
            response = this.sendRequestToBlc(blcId, request);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, this.getName() + ".processRequest(): " + "Caught exception while sending management request to BLC: " + e.getMessage(), e);
            throw e;
        }
        assert (response != null);
        if (!response.isSuccess()) {
            throw response.getException();
        }
        return response;
    }

    protected AbstractManagementResponse processRequest(AbstractManagementRequest request) throws Exception {
        return this.processRequest(SvaConstants.DefaultUUID, request);
    }
}

