/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.faultinsertion;

import com.vmware.sva.blc.AbstractBlcEvent;
import com.vmware.sva.blc.AbstractBusinessLogicComponent;
import com.vmware.sva.faultinsertion.AbstractFault;
import com.vmware.sva.faultinsertion.FaultFactory;
import com.vmware.sva.faultinsertion.FaultInsertion;
import com.vmware.sva.util.SvaHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class BlcEdgeFault
extends AbstractFault {
    public static final String BLC_CLASS_OPTION = "-blcClass";
    public static final String BLC_STATE_OPTION = "-blcState";
    public static final String EVENT_CLASS_OPTION = "-eventClass";
    public static final String FAIL_NEXT_PLATFORM_COMMAND_OPTION = "-failNextPlatformCommand";
    public static final String DEFAULT_BLC_CLASS = ".*";
    public static final String DEFAULT_BLC_STATE = ".*";
    public static final String DEFAULT_EVENT_CLASS = ".*";
    public static final boolean DEFAULT_FAIL_NEXT_PLATFORM_COMMAND = false;
    public static final FaultFactory<BlcEdgeFault> FACTORY = new Factory();
    private final String initialBlcClass;
    private final String initialBlcState;
    private final String initialEventClass;
    private final boolean initialFailNextPlatformCommand;
    private String blcClass = ".*";
    private String blcState = ".*";
    private String eventClass = ".*";
    private boolean failNextPlatformCommand = false;
    private Pattern pattern = null;

    static BlcEdgeFault create(String name, List<String> attribs) {
        LocalAttribs localAttribs;
        BlcEdgeFault.checkNotNull(attribs, "attribs");
        attribs = new ArrayList<String>(attribs);
        try {
            localAttribs = new LocalAttribs(attribs);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Problem setting initial attributes", e);
            localAttribs = new LocalAttribs();
        }
        return new BlcEdgeFault(name, attribs, localAttribs);
    }

    BlcEdgeFault(String name, List<String> superAttribs, LocalAttribs localAttribs) {
        super(name, superAttribs);
        localAttribs.updateAttribs(this);
        this.initialBlcClass = this.blcClass;
        this.initialBlcState = this.blcState;
        this.initialEventClass = this.eventClass;
        this.initialFailNextPlatformCommand = this.failNextPlatformCommand;
    }

    @Override
    public String toString() {
        return super.toString() + " " + BLC_CLASS_OPTION + " " + this.getBlcClass() + " " + BLC_STATE_OPTION + " " + this.getBlcState() + " " + EVENT_CLASS_OPTION + " " + this.getEventClass() + " " + FAIL_NEXT_PLATFORM_COMMAND_OPTION + " " + this.getFailNextPlatformCommand();
    }

    @Override
    public void reset() {
        super.reset();
        this.setBlcClass(this.initialBlcClass);
        this.setBlcState(this.initialBlcState);
        this.setEventClass(this.initialEventClass);
        this.setFailNextPlatformCommand(this.initialFailNextPlatformCommand);
    }

    @Override
    public void set(List<String> attribs) throws Exception {
        LocalAttribs localAttribs = new LocalAttribs(attribs);
        super.set(attribs);
        localAttribs.updateAttribs(this);
    }

    public synchronized String getBlcClass() {
        return this.blcClass;
    }

    public synchronized void setBlcClass(String blcClass) {
        BlcEdgeFault.checkNotNull(blcClass, "blcClass");
        this.blcClass = blcClass;
        this.pattern = null;
    }

    public synchronized String getBlcState() {
        return this.blcState;
    }

    public synchronized void setBlcState(String blcState) {
        BlcEdgeFault.checkNotNull(blcState, "blcState");
        this.blcState = blcState;
        this.pattern = null;
    }

    public synchronized String getEventClass() {
        return this.eventClass;
    }

    public synchronized void setEventClass(String eventClass) {
        BlcEdgeFault.checkNotNull(eventClass, "eventClass");
        this.eventClass = eventClass;
        this.pattern = null;
    }

    public synchronized boolean getFailNextPlatformCommand() {
        return this.failNextPlatformCommand;
    }

    public synchronized void setFailNextPlatformCommand(boolean failNextPlatformCommand) {
        this.failNextPlatformCommand = failNextPlatformCommand;
    }

    public void checkFault(Class<? extends AbstractBusinessLogicComponent> edgeBlcClass, int edgeBlcState, Class<? extends AbstractBlcEvent> edgeEventClass) {
        if (this.getRepeat() > 0 && this.checkEdge(edgeBlcClass, edgeBlcState, edgeEventClass) && this.checkTrigger()) {
            if (this.getFailNextPlatformCommand()) {
                this.doFailNextCommand();
            } else {
                boolean oldReboot = this.isReboot();
                this.setReboot(true);
                try {
                    this.doFault();
                }
                catch (Exception e) {
                    throw SvaHelper.initCause(new AssertionError((Object)"Unexpected exception"), e);
                }
                finally {
                    this.setReboot(oldReboot);
                }
            }
        }
    }

    private boolean checkEdge(Class<? extends AbstractBusinessLogicComponent> edgeBlcClass, int edgeBlcState, Class<? extends AbstractBlcEvent> edgeEventClass) {
        StringBuilder edgeName = new StringBuilder();
        edgeName.append(edgeBlcClass.getName());
        edgeName.append(' ');
        edgeName.append(edgeBlcState);
        edgeName.append(' ');
        edgeName.append(edgeEventClass.getName());
        return this.getPattern().matcher(edgeName).matches();
    }

    private synchronized Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.blcClass + ' ' + this.blcState + ' ' + this.eventClass);
        }
        return this.pattern;
    }

    void doFailNextCommand() {
        FaultInsertion.PLATFORM_FAIL_NEXT_COMMAND.setReboot(this.isReboot());
        FaultInsertion.PLATFORM_FAIL_NEXT_COMMAND.setRepeat(1);
        FaultInsertion.PLATFORM_FAIL_NEXT_COMMAND.setSkip(0);
        FaultInsertion.PLATFORM_FAIL_NEXT_COMMAND.setDelay(this.getDelay());
    }

    static class LocalAttribs {
        private String blcClass = null;
        private String blcState = null;
        private String eventClass = null;
        private Boolean failNextPlatformCommand = null;

        LocalAttribs() {
            this.blcClass = ".*";
            this.blcState = ".*";
            this.eventClass = ".*";
            this.failNextPlatformCommand = false;
        }

        LocalAttribs(List<String> attribs) throws Exception {
            Iterator<String> iter = attribs.iterator();
            while (iter.hasNext()) {
                String elem = iter.next();
                if (elem.equalsIgnoreCase(BlcEdgeFault.BLC_CLASS_OPTION)) {
                    this.blcClass = LocalAttribs.getParam(iter, BlcEdgeFault.BLC_CLASS_OPTION);
                    continue;
                }
                if (elem.equalsIgnoreCase(BlcEdgeFault.BLC_STATE_OPTION)) {
                    this.blcState = LocalAttribs.getParam(iter, BlcEdgeFault.BLC_STATE_OPTION);
                    continue;
                }
                if (elem.equalsIgnoreCase(BlcEdgeFault.EVENT_CLASS_OPTION)) {
                    this.eventClass = LocalAttribs.getParam(iter, BlcEdgeFault.EVENT_CLASS_OPTION);
                    continue;
                }
                if (!elem.equalsIgnoreCase(BlcEdgeFault.FAIL_NEXT_PLATFORM_COMMAND_OPTION)) continue;
                this.failNextPlatformCommand = Boolean.valueOf(LocalAttribs.getParam(iter, BlcEdgeFault.FAIL_NEXT_PLATFORM_COMMAND_OPTION));
            }
        }

        private static String getParam(Iterator<String> iter, String option) throws Exception {
            if (!iter.hasNext()) {
                throw new Exception("No value provided for option: " + option);
            }
            iter.remove();
            String value = iter.next();
            iter.remove();
            return value;
        }

        void updateAttribs(BlcEdgeFault fault) {
            if (this.blcClass != null) {
                fault.setBlcClass(this.blcClass);
            }
            if (this.blcState != null) {
                fault.setBlcState(this.blcState);
            }
            if (this.eventClass != null) {
                fault.setEventClass(this.eventClass);
            }
            if (this.failNextPlatformCommand != null) {
                fault.setFailNextPlatformCommand(this.failNextPlatformCommand);
            }
        }
    }

    private static class Factory
    implements FaultFactory<BlcEdgeFault> {
        Factory() {
        }

        @Override
        public BlcEdgeFault createFault(String name, List<String> attribs) {
            return BlcEdgeFault.create(name, attribs);
        }
    }
}

