/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.services.watchdog;

import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.domainservice.AbstractServiceResponse;
import com.vmware.sva.domainservice.AbstractSyncService;
import com.vmware.sva.services.watchdog.AbstractWatchdogServiceRequest;
import com.vmware.sva.services.watchdog.CreateWatchdogTimerRequest;
import com.vmware.sva.services.watchdog.CreateWatchdogTimerResponse;
import com.vmware.sva.services.watchdog.WatchdogTimer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public class WatchdogService
extends AbstractSyncService {
    private static final String SVA_WATCHDOG_DEVICE_FILE = "/dev/svadog";
    public static final UUID SERVICE_ID = UUID.fromString("6e41c4c8-e0e9-4c8c-992d-dc1c53d7a4e5");
    private List<WatchdogTimer> timers;
    private static final long serialVersionUID = 1L;

    public WatchdogService(BusinessLogicDomainServiceAPI domain) throws Exception {
        super(SERVICE_ID, "Watchdog Service", domain);
    }

    @Override
    public void start() throws Exception {
        this.log(Level.INFO, "Starting Watchdog Services");
        super.start();
        File svadog = new File(SVA_WATCHDOG_DEVICE_FILE);
        if (!svadog.exists()) {
            String errorMsg = "SVA Watchdog Device File /dev/svadog does not exist!";
            this.log(Level.WARNING, errorMsg);
            throw new Exception(errorMsg);
        }
        this.timers = new ArrayList<WatchdogTimer>();
        this.log(Level.INFO, "Watchdog Services startup complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        this.log(Level.INFO, "Stopping Watchdog Services");
        List<WatchdogTimer> list = this.timers;
        synchronized (list) {
            for (WatchdogTimer timer : this.timers) {
                timer.delete();
            }
        }
        super.stop();
        this.log(Level.INFO, "Watchdog Services shutdown complete");
    }

    @Override
    public AbstractServiceResponse syncRequest(AbstractServiceRequest request) {
        assert (request instanceof AbstractWatchdogServiceRequest);
        if (request instanceof CreateWatchdogTimerRequest) {
            return this.handleCreateTimerRequest((CreateWatchdogTimerRequest)request);
        }
        String errorMsg = "Unrecognized Watchdog Service Request: " + ((Object)((Object)request)).getClass();
        assert (false) : errorMsg;
        this.log(Level.SEVERE, errorMsg);
        return null;
    }

    private CreateWatchdogTimerResponse handleCreateTimerRequest(CreateWatchdogTimerRequest request) {
        UUID requestId = request.getRequestId();
        String name = request.getName();
        int interval = request.getInterval();
        try {
            WatchdogTimer timer = new WatchdogTimer(name, interval, this.timers);
            return new CreateWatchdogTimerResponse(requestId, timer);
        }
        catch (Exception e) {
            return new CreateWatchdogTimerResponse(requestId, e);
        }
    }
}

