/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.services.watchdog;

import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.faultinsertion.FaultInsertion;
import com.vmware.sva.services.watchdog.WatchdogJniApi;
import java.util.List;

public class WatchdogTimer {
    private final String name;
    private final long startTime;
    private int interval;
    private List<WatchdogTimer> list;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchdogTimer(String name, int interval, List<WatchdogTimer> list) throws Exception {
        List<WatchdogTimer> list2 = list;
        synchronized (list2) {
            this.name = name;
            this.interval = interval;
            this.startTime = System.currentTimeMillis();
            this.list = list;
            this.add();
            list.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getInterval() {
        return this.interval;
    }

    public void keepAlive() throws Exception {
        if (SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            FaultInsertion.PLATFORM_WATCHDOG_KEEP_ALIVE.checkFault();
            int error = WatchdogJniApi.getInstance().keepAlive(this.name);
            if (error != 0) {
                throw new Exception("Keep Alive failed for timer: " + this.name + ": " + WatchdogJniApi.getInstance().getErrorString(error));
            }
        }
    }

    public int reset(int newInterval) throws Exception {
        int error;
        long timeRemaining = (long)this.interval * 1000L - (System.currentTimeMillis() - this.startTime);
        if (SvaConstants.ENABLE_SYSTEM_WATCHDOG && (error = WatchdogJniApi.getInstance().setTimeout(this.name, newInterval)) != 0) {
            throw new Exception("Reset " + this.name + ": failed to change timer interval: " + WatchdogJniApi.getInstance().getErrorString(error));
        }
        this.interval = newInterval;
        return (int)(timeRemaining / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long delete() throws Exception {
        List<WatchdogTimer> list = this.list;
        synchronized (list) {
            if (SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
                FaultInsertion.PLATFORM_WATCHDOG_DELETE.checkFault();
                int error = WatchdogJniApi.getInstance().removeTimer(this.name);
                if (error != 0) {
                    throw new Exception("Delete Timer failed for timer: " + this.name + ": " + WatchdogJniApi.getInstance().getErrorString(error));
                }
            }
            this.list.remove(this.name);
            return System.currentTimeMillis() - this.startTime;
        }
    }

    private void add() throws Exception {
        if (SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            FaultInsertion.PLATFORM_WATCHDOG_CREATE.checkFault();
            int error = WatchdogJniApi.getInstance().addTimer(this.name, this.interval);
            if (error != 0) {
                throw new Exception("Create Watchdog Timer failed: " + this.name + " with interval " + this.interval + ": " + WatchdogJniApi.getInstance().getErrorString(error));
            }
        }
    }

    public static void syncOpenFiles() {
        if (SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            WatchdogJniApi.getInstance().syncOpenFiles();
        }
    }

    public static void rebootSystem() throws Exception {
        int error = WatchdogJniApi.getInstance().addTimer("RebootTimer", 0);
        if (error != 0) {
            throw new Exception("Create reboot watchdog timer failed with error " + WatchdogJniApi.getInstance().getErrorString(error));
        }
    }
}

